
#define ARC4RANDOM_MAX 0x100000000
#import <QuartzCore/QuartzCore.h>
#import <OpenGLES/EAGLDrawable.h>

#import "EAGLView.h"

@interface EAGLView (EAGLViewPrivate)

- (BOOL)createFramebuffer;
- (void)destroyFramebuffer;

@end

@interface EAGLView (EAGLViewSprite)

- (void)setupView;

@end

@implementation EAGLView

@synthesize animationInterval;

// You must implement this
+ (Class) layerClass
{
	return [CAEAGLLayer class];
}

const float GoalSize=.5;

//The GL view is stored in the nib file. When it's unarchived it's sent -initWithCoder:
- (id)initWithCoder:(NSCoder*)coder
{
	if((self = [super initWithCoder:coder])) {
		// Get the layer
		CAEAGLLayer *eaglLayer = (CAEAGLLayer*) self.layer;
		
		eaglLayer.opaque = YES;
		eaglLayer.drawableProperties = [NSDictionary dictionaryWithObjectsAndKeys:
										[NSNumber numberWithBool:FALSE], kEAGLDrawablePropertyRetainedBacking, kEAGLColorFormatRGBA8, kEAGLDrawablePropertyColorFormat, nil];
		
		context = [[EAGLContext alloc] initWithAPI:kEAGLRenderingAPIOpenGLES1];
		
		if(!context || ![EAGLContext setCurrentContext:context] || ![self createFramebuffer]) {
			[self release];
			return nil;
		}
		
		animationInterval = 1.0 / 60.0;
		
		[self setupView];
		[self TimerTick];
	}
	
	return self;
}


- (void)layoutSubviews
{
	[EAGLContext setCurrentContext:context];
	[self destroyFramebuffer];
	[self createFramebuffer];
	//[self drawView];
	[self TimerTick];
}


- (BOOL)createFramebuffer
{
	glGenFramebuffersOES(1, &viewFramebuffer);
	glGenRenderbuffersOES(1, &viewRenderbuffer);
	
	glBindFramebufferOES(GL_FRAMEBUFFER_OES, viewFramebuffer);
	glBindRenderbufferOES(GL_RENDERBUFFER_OES, viewRenderbuffer);
	[context renderbufferStorage:GL_RENDERBUFFER_OES fromDrawable:(id<EAGLDrawable>)self.layer];
	glFramebufferRenderbufferOES(GL_FRAMEBUFFER_OES, GL_COLOR_ATTACHMENT0_OES, GL_RENDERBUFFER_OES, viewRenderbuffer);
	
	glGetRenderbufferParameterivOES(GL_RENDERBUFFER_OES, GL_RENDERBUFFER_WIDTH_OES, &backingWidth);
	glGetRenderbufferParameterivOES(GL_RENDERBUFFER_OES, GL_RENDERBUFFER_HEIGHT_OES, &backingHeight);
	
	if(glCheckFramebufferStatusOES(GL_FRAMEBUFFER_OES) != GL_FRAMEBUFFER_COMPLETE_OES) {
		NSLog(@"failed to make complete framebuffer object %x", glCheckFramebufferStatusOES(GL_FRAMEBUFFER_OES));
		return NO;
	}
	
	return YES;
}


- (void)destroyFramebuffer
{
	glDeleteFramebuffersOES(1, &viewFramebuffer);
	viewFramebuffer = 0;
	glDeleteRenderbuffersOES(1, &viewRenderbuffer);
	viewRenderbuffer = 0;
	
	if(depthRenderbuffer) {
		glDeleteRenderbuffersOES(1, &depthRenderbuffer);
		depthRenderbuffer = 0;
	}
}


- (void)startAnimation
{
	Ticks=99;
	[[UIAccelerometer sharedAccelerometer] setUpdateInterval:(1.0 / 100)];
	[[UIAccelerometer sharedAccelerometer] setDelegate:self];
	[UIApplication sharedApplication].statusBarHidden=YES;
	[UIApplication sharedApplication].idleTimerDisabled = YES;
	animationTimer = [NSTimer scheduledTimerWithTimeInterval:animationInterval target:self selector:@selector(TimerTick) userInfo:nil repeats:YES];
//[music PlayLooping];	
//[ambient PlayLooping];	

}
- (void)TimerTick{
	Ticks++;
	if (TouchTime>0) TouchTime++;
	if (Ticks==1 && GameState==2) {
		if (!ispaused) [self AnimateGame];
	
	};
	if (Ticks>=2) {
	Ticks=0;
		switch (GameState)
		{
			case 1:
				[self drawMenu];
				break;
			case 2:
				[self drawView];
				break;
			case 3:
				[self drawScore];
				break;
			case 4:
				[self drawHelp];
			default:
				break;
		}
	
	}
	
	
}
-(void)drawPaused{

	
	[myfont MidPrintTextX:0 Y:0 Z:.3 Text:"Paused"];
	
	glColor4f(1, 1, 1, .7f);	
	
	[MenuTarget DrawAniSpriteX:0 Y:-.5 W:1.8 H:.3 R:0 F:15 Flip:0];
	//[MenuTarget DrawAniSpriteX:.5 Y:-.5 W:.8 H:.3 R:0 F:10 Flip:0];
	
	[MenuTarget DrawAniSpriteX:-.5 Y:-1 W:.8 H:.3 R:0 F:15 Flip:0];
	[MenuTarget DrawAniSpriteX:.5 Y:-1 W:.8 H:.3 R:0 F:15 Flip:0];
	glColor4f(1, 1, 1, 1);	
	
	[myfont MidPrintTextX:0 Y:-.5 Z:0.1 Text:"Resume Game"];
	
	[myfont MidPrintTextX:.5 Y:-.95 Z:0.1 Text:"Select"];
	if (AccelXzero<-900) {
	[myfont MidPrintTextX:.5 Y:-1.05 Z:0.1 Text:"Tilt Play"];
	}else{
		[myfont MidPrintTextX:.5 Y:-1.05 Z:0.1 Text:"Touch Play"];
	
	}
	
	[myfont MidPrintTextX:-.5 Y:-1 Z:0.1 Text:"End Game"];
	
	//[myfont MidPrintTextX:.5 Y:-1 Z:0.1 Text:"Quit Game"];
	
	
	

}
- (void)drawHelp{
	
	[EAGLContext setCurrentContext:context];
	
	glBindFramebufferOES(GL_FRAMEBUFFER_OES, viewFramebuffer);
	glClear (GL_COLOR_BUFFER_BIT);
	glColor4f(1, 1, 1, .5f);
	[Backdrop DrawSprite];
	glColor4f(1, 1, 1, 1);
	//[StarField->mysprite DrawTiledSpriteX:0 Y:0 W:3 H:3 TOX:0 TOY:0 TW:.7 TH:.7 R:0];
	//glColor4f(1, 1, 1, 0.5);
	//[StarField->mysprite DrawTiledSpriteX:0 Y:0 W:5 H:5 TOX:0 TOY:0 TW:1 TH:1 R:StarField->Rot];
	//[StarField DoAnimate];
	//glColor4f(1, 1, 1, 1);
	float ypos=1.0;
	switch (GameStateTime) {
		case 0:
			[myfont MidPrintTextX:0 Y:1.2 Z:0.2 Text:"Gameplay"];
  		  //[myfont PrintTextX:-.95 Y:ypos Z:0.1 Text:"123456789012345678901234567890"];ypos-=.1;
			[ShipG->mysprite DrawAniSpriteX:.8 Y:ypos+.1 W:.2 H:.2 R:180  F:0 Flip:0];
			
			[myfont PrintTextX:-.95 Y:ypos Z:0.1 Text:"Use your green ship"];ypos-=.1;
			[Ball->mysprite DrawAniSpriteX:.8 Y:ypos W:.2 H:.2 R:0  F:1 Flip:0];
			[myfont PrintTextX:-.95 Y:ypos Z:0.1 Text:"to push the ball "];ypos-=.1;
			[myfont PrintTextX:-.95 Y:ypos Z:0.1 Text:"between the satellites of"];ypos-=.1;
			[Sat1->mysprite DrawAniSpriteX:.8 Y:ypos W:.2 H:.2 R:0  F:1 Flip:0];
			[myfont PrintTextX:-.95 Y:ypos Z:0.1 Text:"the red ship's goal"];ypos-=.1;
			ypos-=.1;
			[myfont PrintTextX:-.95 Y:ypos Z:0.1 Text:"Colliding with the enemy ship"];ypos-=.1;
			[myfont PrintTextX:-.95 Y:ypos Z:0.1 Text:"will knock it of course but"];ypos-=.1;
			[ShipR->mysprite DrawAniSpriteX:.8 Y:ypos W:.2 H:.2 R:0  F:1 Flip:0];
			[myfont PrintTextX:-.95 Y:ypos Z:0.1 Text:"stuns you both."];ypos-=.1;
			ypos-=.1;
			[myfont PrintTextX:-.95 Y:ypos Z:0.1 Text:"Each game will play until a"];ypos-=.1;
			[myfont PrintTextX:-.95 Y:ypos Z:0.1 Text:"player achieves three goals,"];ypos-=.1;
			[myfont PrintTextX:-.95 Y:ypos Z:0.1 Text:"The CPU skill will increase"];ypos-=.1;
			[myfont PrintTextX:-.95 Y:ypos Z:0.1 Text:"with each game."];ypos-=.1;
			ypos-=.1;
			[myfont PrintTextX:-.95 Y:ypos Z:0.1 Text:"In the later levels"];ypos-=.1;
			[myfont PrintTextX:-.95 Y:ypos Z:0.1 Text:"floating asteroids will"];ypos-=.1;
			[Asteroid[0]->mysprite DrawAniSpriteX:.8 Y:ypos W:.2 H:.2 R:0  F:12 Flip:0];
			[myfont PrintTextX:-.95 Y:ypos Z:0.1 Text:"appear in the play area, "];ypos-=.1;
			[myfont PrintTextX:-.95 Y:ypos Z:0.1 Text:"Ships and the ball will "];ypos-=.1;
			
			[myfont PrintTextX:-.95 Y:ypos Z:0.1 Text:"bounce off asteroids."];ypos-=.1;
			  
			 
			
			ypos-=.1;
			break;
		case 1:
			[myfont MidPrintTextX:0 Y:1.2 Z:0.2 Text:"Controls"];
			
			//[myfont PrintTextX:-.95 Y:ypos Z:0.1 Text:"1234567890123456789012345678"];ypos-=.1;
			[myfont PrintTextX:-.95 Y:ypos Z:0.1 Text:"In tilt mode you can control"];ypos-=.1;
			[myfont PrintTextX:-.95 Y:ypos Z:0.1 Text:"the game by tilting the device"];ypos-=.1;
			ypos-=.1;
			[myfont PrintTextX:-.95 Y:ypos Z:0.1 Text:"You can also fly your ship by"];ypos-=.1;
			[myfont PrintTextX:-.95 Y:ypos Z:0.1 Text:"touching a point on the screen"];ypos-=.1;
			[myfont PrintTextX:-.95 Y:ypos Z:0.1 Text:"to move to it, or by dragging"];ypos-=.1;
			[myfont PrintTextX:-.95 Y:ypos Z:0.1 Text:"to control the flight "];ypos-=.1;
			[MoveTarget->mysprite DrawAniSpriteX:.8 Y:ypos W:.2 H:.2 R:0  F:0 Flip:0];
			[myfont PrintTextX:-.95 Y:ypos Z:0.1 Text:"direction"];ypos-=.1;
			ypos-=.1;
			  
			[myfont PrintTextX:-.95 Y:ypos Z:0.1 Text:"If the ball gets behind you, a"];ypos-=.1;
			[myfont PrintTextX:-.95 Y:ypos Z:0.1 Text:"teleport icon will appear at "];ypos-=.1;
			[myfont PrintTextX:-.95 Y:ypos Z:0.1 Text:"your goal, touch it to leap"];ypos-=.1;
			
			[myfont PrintTextX:-.95 Y:ypos Z:0.1 Text:"back to defend your goal."];ypos-=.1;
			[TeleportTarget->mysprite DrawAniSpriteX:.8 Y:ypos+.05 W:.35 H:.2 R:0  F:13 Flip:0];
			ypos-=.1;
			[myfont PrintTextX:-.95 Y:ypos Z:0.1 Text:"To pause the game, touch and"];ypos-=.1;
			[myfont PrintTextX:-.95 Y:ypos Z:0.1 Text:"hold on the pause button in "];ypos-=.1;
			[myfont PrintTextX:-.95 Y:ypos Z:0.1 Text:"the bottom left hand corner of"];ypos-=.1;
			[myfont PrintTextX:-.95 Y:ypos Z:0.1 Text:"the screen."];ypos-=.1;
			   
			break;
		case 2:
			[myfont MidPrintTextX:0 Y:1.2 Z:0.2 Text:"Powerups"];
			//[myfont PrintTextX:-.95 Y:ypos Z:0.1 Text:"1234567890123456789012345678"];ypos-=.1;
			[Powerups->mysprite DrawAniSpriteX:.8 Y:ypos W:.2 H:.2 R:0  F:0 Flip:0];
			[myfont PrintTextX:-.95 Y:ypos Z:0.1 Text:"Turbo:"];ypos-=.1;
			[myfont PrintTextX:-.95 Y:ypos Z:0.1 Text:"By adding booster rockets"];ypos-=.1;
			[myfont PrintTextX:-.95 Y:ypos Z:0.1 Text:"to your wing tips, your ship"];ypos-=.1;
			[myfont PrintTextX:-.95 Y:ypos Z:0.1 Text:"will increase in speed, giving"];ypos-=.1;
			[myfont PrintTextX:-.95 Y:ypos Z:0.1 Text:"you more striking power, and"];ypos-=.1;
			[myfont PrintTextX:-.95 Y:ypos Z:0.1 Text:"allowing you to outrun"];ypos-=.1;
			[myfont PrintTextX:-.95 Y:ypos Z:0.1 Text:"your opponent"];ypos-=.1;
			ypos-=.1;
			[Powerups->mysprite DrawAniSpriteX:.8 Y:ypos W:.2 H:.2 R:0  F:6 Flip:0];
			[myfont PrintTextX:-.95 Y:ypos Z:0.1 Text:"Mega:"];ypos-=.1;
			[myfont PrintTextX:-.95 Y:ypos Z:0.1 Text:"Supersizes your ship, "];ypos-=.1;
			[myfont PrintTextX:-.95 Y:ypos Z:0.1 Text:"giving you more striking power"];ypos-=.1;
			[myfont PrintTextX:-.95 Y:ypos Z:0.1 Text:"You can also drive through the"];ypos-=.1;
			[myfont PrintTextX:-.95 Y:ypos Z:0.1 Text:"asteroids"];ypos-=.1;
			ypos-=.1;
			[Powerups->mysprite DrawAniSpriteX:.8 Y:ypos W:.2 H:.2 R:0  F:8  Flip:0];
			[myfont PrintTextX:-.95 Y:ypos Z:0.1 Text:"Shield:"];ypos-=.1;
			[myfont PrintTextX:-.95 Y:ypos Z:0.1 Text:"Protects your ship "];ypos-=.1;
			[myfont PrintTextX:-.95 Y:ypos Z:0.1 Text:"from being stunned by "];ypos-=.1;
			[myfont PrintTextX:-.95 Y:ypos Z:0.1 Text:"collisions"];ypos-=.1;
			
			ypos-=.1;
			[Powerups->mysprite DrawAniSpriteX:.8 Y:ypos W:.2 H:.2 R:0  F:12  Flip:0];
			[myfont PrintTextX:-.95 Y:ypos Z:0.1 Text:"Magnet:"];ypos-=.1;
			[myfont PrintTextX:-.95 Y:ypos Z:0.1 Text:"Bolt-on Electromagnets"];ypos-=.1;
			[myfont PrintTextX:-.95 Y:ypos Z:0.1 Text:"will slowly suck the ball"];ypos-=.1;
			[myfont PrintTextX:-.95 Y:ypos Z:0.1 Text:"towards your ship."];ypos-=.1;
			   
			break;
		case 3:
			[myfont MidPrintTextX:0 Y:1.2 Z:0.2 Text:"Credits"];
		   
		  //[myfont PrintTextX:-.95 Y:ypos Z:0.1 Text:"1234567890123456789012345678"];ypos-=.1;
			[myfont PrintTextX:-.95 Y:ypos Z:0.1 Text:"Space Hockey"];ypos-=.1;
			[myfont PrintTextX:-.95 Y:ypos Z:0.1 Text:"Copyright 2009 Keith Sear"];ypos-=.1;
			[myfont PrintTextX:-.95 Y:ypos Z:0.1 Text:"http://www.tinyurl.com/k-phone"];ypos-=.1;
			ypos-=.1;
			[myfont PrintTextX:-.95 Y:ypos Z:0.1 Text:"Programming, Game Design and"];ypos-=.1;
			[myfont PrintTextX:-.95 Y:ypos Z:0.1 Text:"general graphics"];ypos-=.1;
			[myfont PrintTextX:-.95 Y:ypos Z:0.1 Text:"by Keith Sear"];ypos-=.1;
			ypos-=.1;
			[myfont PrintTextX:-.95 Y:ypos Z:0.1 Text:"Splash, Title and Ship"];ypos-=.1;
			[myfont PrintTextX:-.95 Y:ypos Z:0.1 Text:"Graphics by Steve Weston"];ypos-=.1;
			[myfont PrintTextX:-.95 Y:ypos Z:0.1 Text:"http://www.approachus.co.uk"];ypos-=.1;
			ypos-=.1;
			[myfont PrintTextX:-.95 Y:ypos Z:0.1 Text:"Sound Effects from"];ypos-=.1;
			[myfont PrintTextX:-.95 Y:ypos Z:0.1 Text:"http://www.freesound.org"];ypos-=.1;
			[myfont PrintTextX:-.95 Y:ypos Z:0.1 Text:"by yewbic,aust_paul,FreqMan"];ypos-=.1;
			[myfont PrintTextX:-.95 Y:ypos Z:0.1 Text:"owyheesound,JimPurbrick"];ypos-=.1;
			[myfont PrintTextX:-.95 Y:ypos Z:0.1 Text:"ejfortin,Syna-Max"];ypos-=.1;
			
			ypos-=.1;
			//[myfont PrintTextX:-.95 Y:ypos Z:0.1 Text:"Thanks for playing!"];ypos-=.1;
			break;
		default:
			
			GameState=1;
			break;
	}

	[myfont MidPrintTextX:0 Y:-1.4 Z:0.1 Text:"Touch Screen to continue"];ypos-=.1;
	glBindRenderbufferOES(GL_RENDERBUFFER_OES, viewRenderbuffer);
	[context presentRenderbuffer:GL_RENDERBUFFER_OES];
	
	
}
- (void)drawScore{
	
	[EAGLContext setCurrentContext:context];
	
	glBindFramebufferOES(GL_FRAMEBUFFER_OES, viewFramebuffer);
	glClear (GL_COLOR_BUFFER_BIT);
	[Backdrop DrawSprite];
	//[StarField->mysprite DrawTiledSpriteX:0 Y:0 W:3 H:3 TOX:0 TOY:0 TW:.7 TH:.7 R:0];
	//glColor4f(1, 1, 1, 0.5);
	[StarField->mysprite DrawTiledSpriteX:0 Y:0 W:5 H:5 TOX:0 TOY:0 TW:1 TH:1 R:StarField->Rot];
	[StarField DoAnimate];
	//glColor4f(1, 1, 1, 1);
	[FX->mysprite DrawSpriteX:-0.03 Y:0 W:3 H:3 R:0];	
	[FX FadeAX:10 Y:0 W:44 H:64];
	[FX Refresh];
	if (ShipG->AnimFrameTime==0){
		ShipG->AnimFrameTime=-1;
		[ShipG FrameTo:0];
	}
	if (ShipR->AnimFrameTime==0){
		ShipR->AnimFrameTime=-1;
		[ShipR FrameTo:0];
	}
	
	//if (GameStateTime>40 || GameStateTime<20){
	[Sat1 DrawSprite];
	[Sat2 DrawSprite];
	[Sat3 DrawSprite];
	[Sat4 DrawSprite];
	for (int i=0;i<astcount;i++){
	[Asteroid[i] DrawSprite];}
	
	[Ball DrawSprite];
	
	if (ShipG->Frame!=0 || (GameStateTime>40 && Rscore<3)){
	[ShipG DrawSprite];
	[ShipR DrawSprite];
	}
	//}
	float fz=.3;
	if (GameStateTime==0) GameStateTime=1;
	float gst=GameStateTime; 
	if (GameStateTime<20) fz=.3/(20/gst);
	if (GameStateTime>40) fz=(.3/(20/(60-gst)));
	if (GameStateTime==40 && !(Rscore>=3)) 		[self NewRound:YES];
	if (GameStateTime>60) {
		
		[ShipR FrameTo:0];
		[ShipG FrameTo:0];
		if (Rscore>=3) {
			GameStateTime=-1;
			GameState=1;
			if (Score>HiScore) HiScore=Score;
			
			}else GameState=2;
	}

	char ch[100];
	glColor4f(0, 0, 0, 0.3);
	[myfont DrawSolidX:0 Y:1.5 W:2 H:.25 R:0];
	glColor4f(1, 1, 1, 1);
	sprintf(ch,"Score: %d",Score);
	[myfont PrintTextX:-.9 Y:1.45 Z:0.07 Text:ch];
	if (Rscore>=3) {
	[myfont MidPrintTextX:0 Y:0 Z:fz Text:"Game Over"];
	if (Score>HiScore) [myfont MidPrintTextX:0 Y:-.5 Z:fz*.6 Text:"New Hiscore!"];
	} else
	{

	if (RoundNum!=1){
		sprintf(ch,"Round %d",RoundNum);
		[myfont MidPrintTextX:0 Y:1.0 Z:fz Text:ch];
	}
	else{
		sprintf(ch,"Game %d",GameNum);
		[myfont MidPrintTextX:0 Y:1.15 Z:fz Text:ch];
		[myfont MidPrintTextX:0 Y:0.85 Z:fz Text:"Round 1"];
	
	}
	
	
	
	
	sprintf(ch,"%d - %d",Gscore,Rscore);
	[myfont MidPrintTextX:0 Y:0 Z:fz Text:ch];
	[myfont MidPrintTextX:0 Y:-1.0 Z:fz Text:"Get Ready!"];
	}
	
	if (ispaused) {
		[self drawPaused];
	} else{
	GameStateTime++;}
	glBindRenderbufferOES(GL_RENDERBUFFER_OES, viewRenderbuffer);
	[context presentRenderbuffer:GL_RENDERBUFFER_OES];

}

- (void)drawMenu
{

	if (GameStateTime==0){
		GameStateTime++;
		
		[Backdrop LoadPvrSprite:@"TitleBack"];

		//[var dealloc];
		[Backdrop SizeToW:3.2 H:3.2];
		[Backdrop AnimRotate:0];
		[Backdrop RotateTo:0];
		[Backdrop FadeTo:0];
		[Backdrop AnimFade:.05];
		[music Stop];
		
		//[music Play];
		[ambient PlayLooping];
	}
	[EAGLContext setCurrentContext:context];
	
	glBindFramebufferOES(GL_FRAMEBUFFER_OES, viewFramebuffer);
	glClear (GL_COLOR_BUFFER_BIT);
	//[Backdrop->mysprite DrawTiledSpriteX:0 Y:0 W:5 H:5 TOX:0 TOY:0 TW:1 TH:1 R:StarField->Rot];
	[StarField->mysprite DrawTiledSpriteX:0 Y:0 W:5 H:5 TOX:0 TOY:0 TW:1 TH:1 R:StarField->Rot];
	[StarField DoAnimate];

	[Backdrop DrawSprite];
	//[StarField->mysprite DrawTiledSpriteX:0 Y:0 W:3 H:3 TOX:0 TOY:0 TW:.7 TH:.7 R:0];
	//glColor4f(1, 1, 1, 0.5);
	glColor4f(1, 1, 1, .7f);	

	[MenuTarget DrawAniSpriteX:-.5 Y:-.5 W:.8 H:.3 R:0 F:15 Flip:0];
	[MenuTarget DrawAniSpriteX:.5 Y:-.5 W:.8 H:.3 R:0 F:15 Flip:0];
	
	[MenuTarget DrawAniSpriteX:-.5 Y:-1 W:.8 H:.3 R:0 F:15 Flip:0];
	[MenuTarget DrawAniSpriteX:.5 Y:-1 W:.8 H:.3 R:0 F:15 Flip:0];
	glColor4f(1, 1, 1, 1);	
	
	[myfont MidPrintTextX:-.5 Y:-.45 Z:0.1 Text:"Start"];
	[myfont MidPrintTextX:-.5 Y:-.55 Z:0.1 Text:"Touch Game"];
	[myfont MidPrintTextX:.5 Y:-.45 Z:0.1 Text:"Start"];
	[myfont MidPrintTextX:.5 Y:-.55 Z:0.1 Text:"Tilt Game"];

	[myfont MidPrintTextX:-.5 Y:-1 Z:0.1 Text:"How To Play"];

	[myfont MidPrintTextX:.5 Y:-1 Z:0.1 Text:"Credits"];

	
	//[myfont MidPrintTextX:0 Y:.5 Z:0.1 Text:"Press Here for Touch game"];
	//[myfont MidPrintTextX:0 Y:-.5 Z:0.1 Text:"Press Here for Tilt game"];

	char ch[100];
	glColor4f(0, 0, 0, 0.7);
	//-(void)DrawSolidX:(float)Xpos Y:(float)Ypos W:(float)Wid H:(float)Hei R:(float)Rot 
	[myfont DrawSolidX:0 Y:-1.5 W:2 H:.25 R:0];
	glColor4f(1, 1, 1, 1);
	sprintf(ch,"HiScore: %d",HiScore);
	[myfont PrintTextX:-.9 Y:-1.45 Z:0.07 Text:ch];	
	glBindRenderbufferOES(GL_RENDERBUFFER_OES, viewRenderbuffer);
	[context presentRenderbuffer:GL_RENDERBUFFER_OES];

}

- (void)stopAnimation
{
	//[music Stop];
	//[ambient Stop];
	[animationTimer invalidate];
	animationTimer = nil;
	[UIApplication sharedApplication].idleTimerDisabled = NO;
}


- (void)setAnimationInterval:(NSTimeInterval)interval
{
	animationInterval = interval;
	
	if(animationTimer) {
		[self stopAnimation];
		[self startAnimation];
	}
}
-(void)DoSettingSprite:(IPCoreSpriteObj*)Sprite Sname:(NSString *)Sname Write:(BOOL)save{
	[IPCoreSetting DoSettingFloat:&Sprite->Xpos SName:[Sname stringByAppendingString:@"_Xpos"] Write:save];
	[IPCoreSetting DoSettingFloat:&Sprite->Ypos SName:[Sname stringByAppendingString:@"_Ypos"] Write:save];
	[IPCoreSetting DoSettingFloat:&Sprite->Wid SName:[Sname stringByAppendingString:@"_Wid"] Write:save];
	[IPCoreSetting DoSettingFloat:&Sprite->Hei SName:[Sname stringByAppendingString:@"_Hei"] Write:save];
	[IPCoreSetting DoSettingFloat:&Sprite->Rot SName:[Sname stringByAppendingString:@"_Rot"] Write:save];
	[IPCoreSetting DoSettingFloat:&Sprite->Alp SName:[Sname stringByAppendingString:@"_Alp"] Write:save];
	[IPCoreSetting DoSettingFloat:&Sprite->Frame SName:[Sname stringByAppendingString:@"_Frame"] Write:save];
	
	[IPCoreSetting DoSettingFloat:&Sprite->AnimRotating SName:[Sname stringByAppendingString:@"_AnimRotating"] Write:save];
	[IPCoreSetting DoSettingFloat:&Sprite->AnimRotatingTime SName:[Sname stringByAppendingString:@"_AnimRotatingTime"] Write:save];
	[IPCoreSetting DoSettingFloat:&Sprite->AnimScalingX SName:[Sname stringByAppendingString:@"_AnimScalingX"] Write:save];
	[IPCoreSetting DoSettingFloat:&Sprite->AnimScalingY SName:[Sname stringByAppendingString:@"_AnimScalingY"] Write:save];
	[IPCoreSetting DoSettingFloat:&Sprite->AnimScalingTime SName:[Sname stringByAppendingString:@"_AnimScalingTime"] Write:save];
	[IPCoreSetting DoSettingFloat:&Sprite->AnimFading SName:[Sname stringByAppendingString:@"_AnimFading"] Write:save];
	[IPCoreSetting DoSettingFloat:&Sprite->AnimFrameStep SName:[Sname stringByAppendingString:@"_AnimFrameStep"] Write:save];
	[IPCoreSetting DoSettingFloat:&Sprite->AnimFrameFrom SName:[Sname stringByAppendingString:@"_AnimFrameFrom"] Write:save];
	[IPCoreSetting DoSettingFloat:&Sprite->AnimFrameTo SName:[Sname stringByAppendingString:@"AnimFrameTo"] Write:save];
	[IPCoreSetting DoSettingInt:&Sprite->AnimFrameTime SName:[Sname stringByAppendingString:@"_AnimFrameTime"] Write:save];
	[IPCoreSetting DoSettingFloat:&Sprite->AnimMoveSpeedX SName:[Sname stringByAppendingString:@"_AnimMoveSpeedX"] Write:save];
	[IPCoreSetting DoSettingFloat:&Sprite->AnimMoveSpeedY SName:[Sname stringByAppendingString:@"_AnimMoveSpeedY"] Write:save];
	[IPCoreSetting DoSettingFloat:&Sprite->AnimMoveEndX SName:[Sname stringByAppendingString:@"_AnimMoveEndX"] Write:save];
	[IPCoreSetting DoSettingFloat:&Sprite->AnimMoveEndY SName:[Sname stringByAppendingString:@"_AnimMoveEndY"] Write:save];
	
	
	/*
	

	float ;
	int ;
	float ;
	float ;
	float ;
	float ;*/

}
-(void)DoSetting:(BOOL)save{
	[IPCoreSetting DoSettingInt:&GameState SName:@"GameState" Write:save];//?
	[IPCoreSetting DoSettingInt:&HiScore SName:@"HiScore" Write:save];//?
	
	if (GameState!=0 && GameState!=1){
		if (!save) {
			// safety net, we dump a game reset to the settings now so if the game crashes we jump to menu 
			//rather than a crash
			int gg=0;
			
			[IPCoreSetting DoSettingInt:&gg SName:@"GameState" Write:YES];		
			[NSUserDefaults resetStandardUserDefaults];
			//exit(0);
		}
		[IPCoreSetting DoSettingInt:&GameNum SName:@"GameNum" Write:save];//?
		[IPCoreSetting DoSettingInt:&RoundNum SName:@"RoundNum" Write:save];//?
		
		[IPCoreSetting DoSettingInt:&Gscore SName:@"Gscore" Write:save];//?
		[IPCoreSetting DoSettingInt:&Rscore SName:@"Rscore" Write:save];//?
		[IPCoreSetting DoSettingInt:&PUtime SName:@"PUtime" Write:save];//?
		[IPCoreSetting DoSettingInt:&PUtype SName:@"PUtype" Write:save];//?
		[IPCoreSetting DoSettingInt:&CpuWait SName:@"CpuWait" Write:save];//?
		[IPCoreSetting DoSettingInt:&RoundTime SName:@"RoundTime" Write:save];//?
		[IPCoreSetting DoSettingInt:&AiLevel SName:@"AiLevel" Write:save];
		[IPCoreSetting DoSettingInt:&Score SName:@"Score" Write:save];//?
		[IPCoreSetting DoSettingFloat:&AccelXzero SName:@"AccelXzero" Write:save];//?
		[self DoSettingSprite:ShipG Sname:@"ShipG" Write:save ];
		[self DoSettingSprite:ShipR Sname:@"ShipR" Write:save ];
		[self DoSettingSprite:ShipGTeleporting Sname:@"ShipGTeleporting" Write:save ];
		[self DoSettingSprite:ShipRTeleporting Sname:@"ShipRTeleporting" Write:save ];
		[self DoSettingSprite:Ball Sname:@"Ball" Write:save ];
		[self DoSettingSprite:PowerupsActive Sname:@"PowerupsActive" Write:save ];
		[self DoSettingSprite:Powerups Sname:@"Powerups" Write:save];
		[IPCoreSetting DoSettingInt:&astcount SName:@"astcount" Write:save];//?
		for (int i=0;i<8;i++){
			[self DoSettingSprite:Asteroid[i] Sname:[NSString stringWithFormat:@"Asteroid%d",i] Write:save];
		}

		if (save) {
				int shipnum;
				if (PUship==ShipG) shipnum=1;
				if (PUship==ShipR) shipnum=2;
			[IPCoreSetting DoSettingInt:&shipnum SName:@"PUship" Write:save];
	} else {
				int shipnum;
				[IPCoreSetting DoSettingInt:&shipnum SName:@"PUship" Write:save];//?
				switch (shipnum){
					case 1:
						PUship=ShipG;
						break;
					case 2:
						PUship=ShipR;
						break;
					default:
						PUship=ShipG;
						break;
				}
		}
	}
	/*
	 IPCoreSpriteObj *ShipG;
	 IPCoreSpriteObj *ShipGTeleporting;
	 IPCoreSpriteObj *ShipR;
	 IPCoreSpriteObj *Ball;
	 IPCoreSpriteObj *Asteroid[4];
	 IPCoreSpriteObj *PowerupsActive;
	 
	 
	 IPCoreSpriteObj *PUship;
	 
	 */
//	[IPCoreSetting DoSettingObj:(id *)ShipG SName:@"ShipG" Write:save];
	}
- (void)Quit{
	//[[NSUserDefaults standardUserDefaults] setInteger:GameState forKey:@"GameState"];
	[self DoSetting:YES];
	
}
- (void)setupView
{
	
//	settings= [[IPCoreSetting alloc] init];
	ispaused=NO;
	GameStateTime=0;
	//NSString *MyPath = [[NSBundle mainBundle] pathForResource:@"bounce" ofType:@"wav"];
	//NSURL *MyUrl =[NSURL fileURLWithPath:MyPath];
	//AVAudioPlayer *a= [[AVAudioPlayer alloc] initWithContentsOfURL:MyUrl error:nil];
	//[a prepareToPlay];
	//[a play];
	// Sets up matrices and transforms for OpenGL ES
	glViewport(0, 0, backingWidth, backingHeight);
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	glOrthof(-1.0f, 1.0f, -1.5f, 1.5f, -1.0f, 1.0f);
	glMatrixMode(GL_MODELVIEW);
	
	// Clears the view with black
	glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
	FX=[[IPCoreDynSprite alloc] init];
	[FX CreateBlankWid:64 Hei:64];
	
	myfont=[[IPCoreSprite alloc] init];
	[myfont LoadSprite:@"Font.png"];
	[myfont DefineTileX:16 Y:8];
	
	ForceField=[[IPCoreSprite alloc] init];
	ForceField->spriteName=@"ForceField.png";
	//[ForceField LoadSprite:@"ForceField.png"];
	
	
	
	PowerupsActive=[[IPCoreSpriteObj alloc] init];
	[PowerupsActive LoadSprite:@"PowerUpsActive.png"];
	[PowerupsActive FadeTo:0];
	[PowerupsActive DefineTileX:4 Y:4];
	
	
	// share a sprite of powerupsactive
	burst=PowerupsActive->mysprite;
	//[burst LoadSprite:@"burst.png"];
	
	// Menu button sprite
	MenuTarget=PowerupsActive->mysprite;
	//MenuTarget=[[IPCoreSprite alloc] init];
	//[MenuTarget LoadSprite:@"MenuTarget.png"];
	
	
	sparks=[[IPCoreSpriteObj alloc] init];
	//sparks->mysprite->spriteName=@"sparks.png";
	[sparks NameSprite:@"sparks.png"];
	[sparks FadeTo:0];
	[sparks DefineTileX:4 Y:2];
	Backdrop=[[IPCoreSpriteObj alloc] init];
	bounce=[[IPCoreSound alloc] init];
	[bounce NameSound:@"bounce" Ext:@"wav"];
	music=[[IPCoreSound alloc] init];
	ambient=[[IPCoreSound alloc] init];
	[ambient NameSound:@"Ambient" Ext:@"mp3"];
	[music NameSound:@"FluidRetroTension" Ext:@"mp3"];
	
	asteroidball=[[IPCoreSound alloc] init];
	[asteroidball NameSound:@"asteroidbounceball" Ext:@"wav"];
	
	powerup=[[IPCoreSound alloc] init];
	[powerup NameSound:@"Powerup" Ext:@"wav"];
	
	asteroidship=[[IPCoreSound alloc] init];
	[asteroidship NameSound:@"asteroidbounceship" Ext:@"wav"];
	
	shock=[[IPCoreSound alloc] init];
	[shock NameSound:@"shock" Ext:@"wav"];
	
	teleport=[[IPCoreSound alloc] init];
	[teleport NameSound:@"teleport" Ext:@"wav"];
	alarm=[[IPCoreSound alloc] init];
	[alarm NameSound:@"alarm" Ext:@"wav"];	
	
		Powerups=[[IPCoreSpriteObj alloc] init];
	///[Powerups LoadPvrSprite:@"tex"];
	
	[Powerups NameSprite:@"Powerups.png"];
	[Powerups DefineTileX:4 Y:4];
	//Powerups->Wid*=.5;
	//Powerups->Hei*=.5;

	StarField=[[IPCoreSpriteObj alloc] init];
	[StarField NameSprite:@"Starfield.png"];
	[StarField FadeTo:.5];
	[StarField AnimRotate:1];
	[StarField SizeToW:2 H:3];
	
	// Spot touched by the user, represents the middle of the virtual joystick
	TouchSpot=[[IPCoreSpriteObj alloc] init];
	[TouchSpot ShareSprite:PowerupsActive];
	[TouchSpot SizeToW:.2 H:.2];
	[TouchSpot FrameTo:12];
 	[TouchSpot FadeTo:0];

	// teleport shares powerupsactive, but it's aspect ratio is different so we fake it to the correct one by scaling
	// the width only
	TeleportTarget=[[IPCoreSpriteObj alloc] init];
	[TeleportTarget ShareSprite:PowerupsActive];
	TeleportTarget->Wid*=2;
	[TeleportTarget FrameTo:13];
	//TeleportTarget->Hei*=2;
	
	
	//[MoveTarget MovetoX:0 Y:0];
	Ball=[[IPCoreSpriteObj alloc] init];
	//Ball->mysprite->spriteName=@"BallSprite.png";
	[Ball NameSprite:@"BallSprite.png"];
	[Ball DefineTileX:4 Y:4];
	//Ball->Wid*=.66;
	//Ball->Hei*=.66;


	//[Ball SizeToW:.2 H:.2];



	//[ShipG SizeToW:.2 H:.2];

	ShipR=[[IPCoreSpriteObj alloc] init];
	[ShipR LoadSprite:@"ShipR.png"];
	[ShipR DefineTileX:4 Y:4];
	ShipR->Wid*=.66;
	ShipR->Hei*=.66;
	//[ShipR SizeToW:.2 H:.2];
	ShipRTeleporting=[[IPCoreSpriteObj alloc] init];
	[ShipRTeleporting ShareSprite:ShipR];
	
	PUtextSize=0;


	Sat1=[[IPCoreSpriteObj alloc] init];
	Sat2=[[IPCoreSpriteObj alloc] init];
	Sat3=[[IPCoreSpriteObj alloc] init];
	Sat4=[[IPCoreSpriteObj alloc] init];
	[Sat1 ShareSprite:Ball];
	[Sat1 SizeToW:.2 H:.2];
	// [Sat1 DefineTileX:2 Y:2];
	[Sat1 AnimFramesFrom:10 To:13.9 Step:.1];
	[Sat2 ShareSprite:Sat1];
	[Sat3 ShareSprite:Sat1];
	[Sat4 ShareSprite:Sat1];


	
	Sat1->FlipMe=1;
	Sat3->FlipMe=1;
	Sat2->Frame=11.3;
	Sat3->Frame=12.5;
	Sat4->Frame=13.7;
	
	ShipG=[[IPCoreSpriteObj alloc] init];
	//}
	[ShipG LoadSprite:@"ShipG.png"];
	[ShipG DefineTileX:4 Y:4];

		ShipG->Wid*=.66;
		ShipG->Hei*=.66;
	
	ShipGTeleporting=[[IPCoreSpriteObj alloc] init];
	[ShipGTeleporting ShareSprite:ShipG];
	

	MoveTarget=[[IPCoreSpriteObj alloc] init];
	[MoveTarget ShareSprite:ShipG];
	[MoveTarget FrameTo:15];
	
	Asteroid[0]=[[IPCoreSpriteObj alloc] init];
	[Asteroid[0] ShareSprite:ShipG];
	//[Asteroid[0] LoadSprite:@"meteor.png"];
	//[Asteroid[0] DefineTileX:2 Y:2];
	[Asteroid[0] AnimRotate:-3];
	[Asteroid[0] FadeTo:0];	
	for (int i=1;i<8;i++){
		Asteroid[i]=[[IPCoreSpriteObj alloc] init];
		//[Asteroid[i] AnimRotate:-3];
		[Asteroid[i] ShareSprite:Asteroid[0]];
		//[Asteroid[i] FadeTo:0];
		[Asteroid[i] CopyAttributes:Asteroid[0]];
		[Asteroid[i] CopyAnim:Asteroid[0]];
	}
	
	[self NewRound:YES];
	// load up our game settings
	
	[self DoSetting:NO];
	if (AiLevel==0) AiLevel=1;
	
	//GameState=[[NSUserDefaults standardUserDefaults] integerForKey:@"GameState"];
	if (GameState==0 || GameState==4 || GameState==1) {GameState=1;GameStateTime=0;} else{
		if (GameState==2 || GameState==3){
	
		ispaused=YES;}
		if (GameState!=1){
			int rnback=1+(arc4random() %8);
			[Backdrop  LoadPvrSprite:[NSString stringWithFormat:@"BACK%d",rnback]];
			
			//[var dealloc];
			[Backdrop SizeToW:4 H:4];
			[Backdrop AnimRotate:.2];
			//[ambient Stop];	
		//[music LoadSound:@"FluidRetroTension" Ext:@"mp3"];
		//[music Play];
			[music PlayLooping];
		}
		
	};
	

		
//	}

}
- (void) DoPowerup:(IPCoreSpriteObj*)Ship{
	if (PUtype==0){	
		[powerup Play];
	PUship=Ship;
		if (Powerups->Frame>=0 && Powerups->Frame<=3.99){
		PUtype=2;
			PUtime=180;
		[PowerupsActive AnimFade:.2];
		if (Ship==ShipG)
			[PowerupsActive FrameTo:1];
		else
			[PowerupsActive FrameTo:4];
			
			}

		if (Powerups->Frame>=12 && Powerups->Frame<=15.99){
			[PowerupsActive AnimFramesFrom:7 To:9 Step:1];
			[PowerupsActive AnimFade:.1];
			//[PowerupsActive AnimRotate:45];
			PUtype=4;
			PUtime=180;
		}	
	if (Powerups->Frame>=8 && Powerups->Frame<=11.99){
		[PowerupsActive AnimFade:.1];
		[PowerupsActive AnimRotate:18];
		[PowerupsActive FrameTo:0];
		PUtype=3;
		PUtime=180;
	}
	if (Powerups->Frame>=4 && Powerups->Frame<=7.99){
		[Ship AnimScaleX:.025 Y:.025 T:10];
	//Ship->Wid*=2;
	//Ship->Hei*=2;
				[PowerupsActive FrameTo:0];
		PUtype=1;
		PUtime=180;
	}
	
	PUtextSize=.05;
	[Powerups AnimScaleX:-.04 Y:-.04 T:6];
	[Powerups AnimFade:-.1];
	}
}
-(void)purge{
	[Ball->mysprite purge];
	[Powerups->mysprite purge];
	[sparks->mysprite purge];
	[shock purge];
	[bounce purge];
	[asteroidball purge];
	[powerup purge];
	[asteroidship purge];
	[powerup purge];
	[teleport purge];
	[alarm purge];
	/*
	 
	 
	 
	 
	 
	 
	bounce=[[IPCoreSound alloc] init];
	[bounce NameSound:@"bounce" Ext:@"wav"];
	music=[[IPCoreSound alloc] init];
	//[music LoadSound:@"EuroTranceMission" Ext:@"mp3"];
	
	asteroidball=[[IPCoreSound alloc] init];
	[asteroidball NameSound:@"asteroidbounceball" Ext:@"wav"];
	
	powerup=[[IPCoreSound alloc] init];
	[powerup NameSound:@"Powerup" Ext:@"wav"];
	
	asteroidship=[[IPCoreSound alloc] init];
	[asteroidship LoadSound:@"asteroidbounceship" Ext:@"wav"];
	
	shock=[[IPCoreSound alloc] init];
	[shock NameSound:@"shock" Ext:@"wav"];
	
	teleport=[[IPCoreSound alloc] init];
	[teleport NameSound:@"teleport" Ext:@"wav"];
	alarm=[[IPCoreSound alloc] init];
	[alarm NameSound:@"alarm" Ext:@"wav"];	
	*/
	
	
	//[music Stop];
}
- (void) ClearPowerup{
	PUtextSize=0;
	[PowerupsActive AnimRotate:0];
	[PowerupsActive FadeTo:0];
	if (PUtype==1){
		[PUship AnimScaleX:-.025 Y:-.025 T:10];
	//PUship->Wid*=.5;
	//PUship->Hei*=.5;
	}
	PUtype=0;
	
	PUtime=0;
	PUship=nil;
	[self initpowerup];
}
-(void)initpowerup{
	[Powerups FadeTo:1];
	[Powerups SizeToW:0 H:0];
	[Powerups AnimScaleX:.04 Y:.04 T:7];
	int poweruptype=arc4random()%4;
	//poweruptype=3;
	Powerups->Xpos=arc4random();
	Powerups->Ypos=arc4random();
	Powerups->Xpos=((Powerups->Xpos/ARC4RANDOM_MAX)*2.0f)-1.0f;
	Powerups->Ypos=((Powerups->Ypos/ARC4RANDOM_MAX)*3.0f)-1.5f;
	//Powerups->Xpos=-2;
	[Powerups AnimFramesFrom:(poweruptype*4) To:(poweruptype*4+3)+.9 Step:.3];
	//[Powerups AnimRotate:-4];
}
- (void)EndRound{
	[self ClearPowerup];
	GameStateTime=0;
	//[self initpowerup];
	// Animate satellites
	[Sat1 AnimMovetoX:0 Y:1.8 S:0.05];
	[Sat2 AnimMovetoX:0 Y:1.8 S:0.05];
	[Sat3 AnimMovetoX:0 Y:-1.8 S:0.05];
	[Sat4 AnimMovetoX:0 Y:-1.8 S:0.05];
	[TouchSpot AnimFade:-.1];
	[ShipGTeleporting FadeTo:0];
	[ShipRTeleporting FadeTo:0];
	[TeleportTarget FadeTo:0];
	[MoveTarget AnimFade:-.1];
	[Ball FadeTo:0];
//	[ShipG AnimFramesFrom:11.75 To:7 Step:-0.25];
//	ShipG->AnimFrameTime=16;
//	[ShipR AnimFramesFrom:11.75 To:7 Step:-0.25];
//	ShipR->AnimFrameTime=16;

	[ShipR AnimFramesFrom:6 To:10.75 Step:0.25];
	ShipR->AnimFrameTime=19;
	[ShipG AnimFramesFrom:6 To:10.75 Step:0.25];
	ShipG->AnimFrameTime=19;	
	for (int i=0;i<astcount;i++){
	[Asteroid[i] AnimFade:-.1];
	}
}

- (void)RoundInc{
	RoundNum++;
	
	if (Gscore >=3)
	{
		RoundNum=1;
		GameNum++;
		Gscore=0;
		Rscore=0;
		if (AiLevel<6){
			AiLevel+=3;
		} else 	AiLevel++;
		int rnback=1+(arc4random() %8);
		[Backdrop  LoadPvrSprite:[NSString stringWithFormat:@"BACK%d",rnback]];
		
		[Backdrop SizeToW:4 H:4];
		[Backdrop FadeTo:0];
		[Backdrop AnimFade:.05];
	}
	
}
- (void)NewRound:(BOOL)showships{

	[self initpowerup];
	// Animate satellites
	[Sat1 MovetoX:0 Y:1.8];
	[Sat2 MovetoX:0 Y:1.8];
	[Sat3 MovetoX:0 Y:-1.8];
	[Sat4 MovetoX:0 Y:-1.8];

	[ShipRTeleporting FadeTo:0];
	[ShipGTeleporting FadeTo:0];
	[TeleportTarget FadeTo:0];
	[TeleportTarget MovetoX:0 Y:1.2];
	[MoveTarget FadeTo:0];

	[ShipG MovetoX:0 Y:1];
	[ShipG RotateTo:180];
	[Ball ResetSize];
	Ball->Wid*=.80;
	Ball->Hei*=.80;
	float bs=Ball->Wid;
	
	[ShipR MovetoX:0 Y:-1];
	[ShipR RotateTo:0];
	[Ball FadeTo:0];
	if (showships==YES){
		
		ffstate=0;
		ffstatetime=0;
		[Sat1 AnimMovetoX:GoalSize Y:1.4 S:0.05];
		[Sat2 AnimMovetoX:-GoalSize Y:1.4 S:0.05];
		[Sat3 AnimMovetoX:GoalSize Y:-1.4 S:0.05];
		[Sat4 AnimMovetoX:-GoalSize Y:-1.4 S:0.05];
		[Ball SizeToW:bs*4 H:bs*4];
		[Ball AnimScaleX:-bs/5 Y:-bs/5 T:15];
		[Ball AnimFramesFrom:0 To:4.5 Step:.5];
		[Ball MovetoX:0 Y:0];
		[ShipG ResetSize];
		[ShipR ResetSize];
		float sz;
		astcount=GameNum/3;
		if (astcount>8) astcount=8;
		for (int i=0;i<astcount;i++){
			Asteroid[i]->Frame=arc4random()%4+11;
		Asteroid[i]->Xpos=arc4random();
		Asteroid[i]->Ypos=arc4random();
		Asteroid[i]->Xpos=((Asteroid[i]->Xpos/ARC4RANDOM_MAX)*1.6f)-0.8f;
		Asteroid[i]->Ypos=((Asteroid[i]->Ypos/ARC4RANDOM_MAX)*2.4f)-1.2f;
		//	sz=arc4random();
		//sz=((sz/ARC4RANDOM_MAX)*.2f)+.2f;
			sz=.2;
			[Asteroid[i] SizeToW:0 H:0];
			[Asteroid[i] FadeTo:1];
			[Asteroid[i] AnimRotate:-3];
			[Asteroid[i] AnimScaleX:sz/10 Y:sz/10 T:10];
		}
		ShipG->Wid*=.66;
		ShipG->Hei*=.66;
		ShipR->Wid*=.66;
		ShipR->Hei*=.66;
		[Ball AnimFade:.05];
		[ShipR AnimFramesFrom:10.75 To:6 Step:-0.25];
		ShipR->AnimFrameTime=19;
		[ShipG AnimFramesFrom:10.75 To:6 Step:-0.25];
		ShipG->AnimFrameTime=19;
	}else{
		
		ShipG->Frame=0;	
		ShipR->Frame=0;
	}
	RoundTime=20*100;
}
-(void)Bounce:(IPCoreSpriteObj*)sone Off:(IPCoreSpriteObj*)stwo{
	if ([sone Intersects:stwo TolW:1 TolH:1] && PUship==sone && PUtype==1){
		[stwo AnimFade:-.1];
	
	} else 	if ([sone Intersects:stwo TolW:1 TolH:1]) {
		
		if (sone==ShipG || sone==ShipR){
			[asteroidship Play];
			[sone AnimFramesFrom:1 To:3.9 Step:.3];
			sone->AnimFrameTime=6;
			
		} else{
			[asteroidball Play];
		}
	float Xmult,Ymult,xmove,ymove,spd;
	if (stwo->Xpos>sone->Xpos) Xmult=-1; else Xmult=1;
	if (stwo->Ypos>sone->Ypos) Ymult=-1; else Ymult=1;	
	xmove=sone->AnimMoveSpeedX*8;
	ymove=sone->AnimMoveSpeedY*8;
	spd=ShipG->AnimMoveSpeedX+ShipG->AnimMoveSpeedY*1.5;
	//if (PUtype==1 && PUship==ShipG) spd*=2;
	if (spd<.05) spd=.05;	
	if (xmove<.05 && xmove>0) xmove=.05;
	if (ymove<.05 && ymove>0) ymove=.05;
	if (ymove==0 && xmove==0) ymove=.05;
	[sone AnimMovetoX:sone->Xpos+xmove*Xmult Y:sone->Ypos+ ymove*Ymult S:spd];

	CpuWait+=5;
	}

}

- (void)AnimateGame{
	
	// Handle Ship Animation 
	if (ShipG->AnimMoveSpeedX!=0 || ShipG->AnimMoveSpeedY!=0) 
	{
		//check green ship isn't off screen
		if (ShipG->Xpos<-1) ShipG->Xpos=-1;
		if (ShipG->Xpos>1) ShipG->Xpos=1;
		if (ShipG->Ypos<-1.5) ShipG->Ypos=-1.5;
		
		if (ShipG->Ypos>1.5) ShipG->Ypos=1.5;
		if (ShipG->Frame==0) {
			[ShipG AnimFramesFrom:4 To:5.9 Step:.3];
			if (PUtype==2 && PUship==ShipG) [PowerupsActive AnimFramesFrom:2 To:3.9 Step:.3];
			
		}
	}
	else
	{
		if (ShipG->Frame==4 ||ShipG->Frame==5){
			[ShipG FrameTo:0];
			if (PUtype==2 && PUship==ShipG) [PowerupsActive FrameTo:1];
		}
	}
	
	if (ShipG->AnimFrameTime==0){
		ShipG->AnimFrameTime=-1;
		[ShipG FrameTo:0];
		
	}
	
	if (ShipGTeleporting->AnimFrameTime==0) ShipGTeleporting->Alp=0;
	if (ShipRTeleporting->AnimFrameTime==0) ShipRTeleporting->Alp=0;
	
	if (ShipR->AnimMoveSpeedX!=0 || ShipR->AnimMoveSpeedY!=0) 
	{
		if (ShipR->Ypos<-1.5) ShipR->Ypos=-1.5;
		if (ShipR->Frame==0) [ShipR AnimFramesFrom:4 To:5.9 Step:.3];
		if (PUtype==2 && PUship==ShipR) [PowerupsActive AnimFramesFrom:5 To:6.9 Step:.3];
	}
	else
	{
		if (ShipR->Frame==4 ||ShipR->Frame==5){
			[ShipR FrameTo:0];
			if (PUtype==2 && PUship==ShipR) [PowerupsActive FrameTo:4];
			
		}
	}
	
	if (ShipR->AnimFrameTime==0){
		ShipR->AnimFrameTime=-1;
		[ShipR FrameTo:0];
	}
	
	// Ball Wall Bouncing
	if (Ball->AnimMoveSpeedX!=0 || Ball->AnimMoveSpeedY!=0){
		BOOL BounceOccured=NO;
		if (Ball->Xpos>.9) {Ball->AnimMoveEndX=.8;BounceOccured=YES;}
		if (Ball->Xpos<-0.9) {Ball->AnimMoveEndX=-0.8;BounceOccured=YES;}
		if (Ball->Frame<5) {[Ball AnimFramesFrom:5 To:9.5 Step:.5];}
		if (Ball->Ypos<-1.4 && (Ball->Xpos<-GoalSize || Ball->Xpos>GoalSize)) {Ball->AnimMoveEndY=-1.3;BounceOccured=YES;}
		if (Ball->Ypos>1.4 && (Ball->Xpos<-GoalSize || Ball->Xpos>GoalSize)) {Ball->AnimMoveEndY=1.3;BounceOccured=YES;}
		if (BounceOccured==YES){
			[sparks MovetoX:Ball->Xpos Y:Ball->Ypos];
			[sparks FadeTo:1];
			[sparks SizeToW:.5 H:.5];
			[sparks AnimFramesFrom:3 To:5 Step:1];
			sparks->AnimFrameTime=3; 
			ffstatetime=0;
			ffstate=2;
		}
	}
	else
	{
		if (Ball->Xpos>.9) [Ball AnimMovetoX:0.8 Y:Ball->Ypos S:0.1];
		if (Ball->Xpos<-0.9) [Ball AnimMovetoX:-0.8 Y:Ball->Ypos S:0.1] ;
		if (Ball->Ypos<-1.4 && (Ball->Xpos<-GoalSize || Ball->Xpos>GoalSize)) [Ball AnimMovetoX:Ball->Xpos Y:-1.3 S:0.1];
		if (Ball->Ypos>1.4 && (Ball->Xpos<-GoalSize || Ball->Xpos>GoalSize))  [Ball AnimMovetoX:Ball->Xpos Y:1.3 S:0.1];
		if (Ball->Frame>=5) [Ball AnimFramesFrom:0 To:4.5 Step:.5];
		if (PUtype==4){
			if (PUship==ShipG){
				[Ball AnimMovetoX:PUship->Xpos Y:PUship->Ypos-.2 S:.02];
			}
			else
			{
				[Ball AnimMovetoX:PUship->Xpos Y:PUship->Ypos+.2 S:.02];
			}
			
		}
		
	}
	RoundTime--;
	if (RoundTime==0){
		[self RoundInc];
		[self EndRound];
		GameState=3;
	}

	//powerups
	if (PUtime>0){
		PUtime--;
		if (PUtime==0) [self ClearPowerup];
	}
	//power up green
	if ([ShipG Intersects:Powerups TolW:1 TolH:1] && PUtype==0 && PUtime==0) {
		[self DoPowerup:ShipG];
		Score+=20;
	}
	if ([ShipR Intersects:Powerups TolW:1 TolH:1] && PUtype==0 && PUtime==0) {
		[self DoPowerup:ShipR];
	}
	// Green Hits Ball
	if ([ShipG Intersects:Ball TolW:1 TolH:1]) {
		[bounce Play];
		Score+=1;
		float Xmult,Ymult,xmove,ymove,spd;
		if (ShipG->AnimMoveEndX>ShipG->Xpos) Xmult=1; else Xmult=-1;
		if (ShipG->AnimMoveEndY>ShipG->Ypos) Ymult=1; else Ymult=-1;	
		xmove=ShipG->AnimMoveSpeedX*8;
		ymove=ShipG->AnimMoveSpeedY*8;
		spd=ShipG->AnimMoveSpeedX+ShipG->AnimMoveSpeedY*1.5;
		if (PUtype==1 && PUship==ShipG) spd*=2;
		if (spd<.02) spd=.02;	
		if (xmove<.05 && xmove>0) xmove=.05;
		if (ymove<.05 && ymove>0) ymove=.05;
		if (ymove==0 && xmove==0) ymove=.05;
		[Ball AnimMovetoX:Ball->Xpos+xmove*Xmult Y:Ball->Ypos+ ymove*Ymult S:spd];
		ShipG->AnimMoveEndX=ShipG->Xpos;
		ShipG->AnimMoveEndY=ShipG->Ypos;
		CpuWait+=5;
	}//}
	// Red Hits Ball
	if ([ShipR Intersects:Ball TolW:1 TolH:1] && (Ball->Xpos>-1)  && (Ball->Xpos<1)  && (Ball->Ypos>-1.5) && (Ball->Ypos<1.5)  ) {
		[bounce Play];
		float Xmult,Ymult,xmove,ymove,spd;
		if (ShipR->AnimMoveEndX<ShipR->Xpos) Xmult=-1; else Xmult=1;
		if (ShipR->AnimMoveEndY<ShipR->Ypos) Ymult=-1; else Ymult=1;	
		xmove=ShipR->AnimMoveSpeedX*8;
		ymove=ShipR->AnimMoveSpeedY*8;
		spd=ShipR->AnimMoveSpeedX+ShipR->AnimMoveSpeedY*1.5;
		if (PUtype==1 && PUship==ShipR) spd*=2;
		if (spd<.02) spd=.02;	
		if (xmove<.05 && xmove>0) xmove=.05;
		if (ymove<.05 && ymove>0) ymove=.05;
		if (ymove==0 && xmove==0) ymove=.05;
		[Ball AnimMovetoX:Ball->Xpos+xmove*Xmult Y:Ball->Ypos+ ymove*Ymult S:spd];
	}//}
	

	
	if (sparks->AnimFrameTime==0) {[sparks FadeTo:0];}
	
	
	//Teleport Button
	if (Ball->Ypos>ShipG->Ypos && ShipG->Ypos<.7){
		[TeleportTarget FadeTo:1];
	}
	else{
		if (TeleportTarget->AnimFading==0) [TeleportTarget AnimFade:-0.5];
	}
	
	for (int i=0;i<astcount;i++){
		[self Bounce:ShipG Off:Asteroid[i]];
		[self Bounce:ShipR Off:Asteroid[i]];
		[self Bounce:Ball Off:Asteroid[i]];
	}
	
	// handle virtual joystick
	if (TouchTime>0){
		float tx,ty;
		tx=(TouchLastX-TouchStartX);
		ty=(TouchLastY-TouchStartY);
		
		
		if (GameState==2 && (tx<-.1 || tx>.1 || ty<-.1 || ty>.1 )){
			if (tx<=.1 && tx>=-.1) tx=0;
			if (tx>.1) tx-=.1;
			if (tx<-.1) tx+=.1;
			
			if (ty<=.1 && ty>=-.1) ty=0;
			if (ty>.1) ty-=.1;
			if (ty<-.1) ty+=.1;
			//	float f1=abs(ty*100);
			//	float f2=abs(tx*100);
			
			//	float f1=(ty*100);
			//	float f2=-(tx*100);
			
			float myrot=atan(-tx/ty)*180/3.14;
			
			if (ty<0) myrot+=180;
			if (myrot<0) myrot+=360;
			if (ShipG->AnimMoveSpeedX>0 ||ShipG->AnimMoveSpeedY>0  ){
				tx=ShipG->Xpos+tx;
				ty=ShipG->Ypos+ty;
				
			}
			else{
				tx=ShipG->AnimMoveEndX+tx;
				ty=ShipG->AnimMoveEndY+ty;
			}
			
			
			if (ShipG->Frame<1 || ShipG->Frame>3.99) { 
				//Move Player
				//[ShipG RotateTo:myrot];
				[ShipG AnimRotateTo:myrot S:5];
				//if (ty<ShipG->Ypos) [ShipG AnimRotateTo:180 S:5]; else [ShipG AnimRotateTo:0 S:5];
				[MoveTarget MovetoX:tx Y:ty];
				[MoveTarget SizeToW:1 H:1];
				//[MoveTarget AnimScaleX:-.1 Y:-.1 T:8];
				[MoveTarget SizeToW:.2 H:.2];
				[MoveTarget FadeTo:.8];
				[MoveTarget AnimFade:-.2];
				float spd;
				if (PUtype==2 && PUship==ShipG) spd=.07; else spd=.05;
				[ShipG AnimMovetoX:tx Y:ty S:spd];
				
			}
		}
	
	
	
	}
	// CPU AI
	int currentwait=15+(20-AiLevel)*3;
	if (currentwait<5) currentwait=5;
	if (CpuWait>currentwait){
		
		float cpux,cpuy;
		cpux=Ball->Xpos;
		cpuy=Ball->Ypos;
		//if (cpuy<ShipR->Ypos){
		
		
		//}else 
		if (cpuy-.10<ShipR->Ypos ){
			//ball behind cpu
			if (cpux+.3<ShipR->Xpos || cpux-.3>ShipR->Xpos){
				cpuy-=.4;
				if (cpux>0){cpux+=.2;} else if (cpux<0){cpux-=.2;}	
			} else {
				//	if (cpuy-.5<ShipR->Ypos) cpuy-=.4;
				if  (cpux<ShipR->Xpos){cpux+=.5;} else {cpux+=.5;}
			}
			
		}else {
			// ball in front of cpu
			//if (cpuy>ShipR->Ypos){cpuy-=.3;}
			
			if (cpux>-GoalSize && cpux<GoalSize && (cpux+.1<ShipR->Xpos || cpux-.1>ShipR->Xpos)){
				cpuy=ShipR->Ypos;
				//center up
			}
			
			
		}
		if ((Powerups->Xpos+.4>ShipR->Xpos) && (Powerups->Xpos-.4<ShipR->Xpos) && (Powerups->Ypos+.4>ShipR->Ypos) &&  (Powerups->Ypos-.4<ShipR->Ypos) &&(PUtime==0))
		{
			cpux=Powerups->Xpos;
			cpuy=Powerups->Ypos;
		}
		//if (Ball->AnimMoveSpeedY>0) cpuy=ShipR->Ypos;
		float csd=(.005+(0.002*AiLevel));
		if (csd>.05) csd=.05;
		if (ShipR->Ypos<-1.3)  csd=.05;
		//spd=.07; else spd=.05;
		if (!(PUtype==1 && PUship==ShipR)) {
			csd*=1.5;
		if (csd>.07) csd=.07;
		};
		if (ShipR->Frame<1 || ShipR->Frame>3.999){ 
			
			
			
			float txa=cpux-ShipR->Xpos;
			float tya=cpuy-ShipR->Ypos;
			float myrot=atan(-txa/tya)*180/3.14;
			
			if (tya<0) myrot+=180;
			if (myrot<0) myrot+=360;
			
			[ShipR AnimRotateTo:myrot S:5];
			
			[ShipR AnimMovetoX:cpux Y:cpuy S:csd];
			
			if (ShipR->Ypos-.2>Ball->Ypos && ShipG->Ypos<ShipR->Ypos && Ball->Ypos<0 && Ball->Ypos>-1.2 && (ShipR->Frame<1 || ShipR->Frame>3.999)){
				[ShipRTeleporting CopyAttributes:ShipR];
				[ShipR MovetoX:0 Y:-1.2];
				[teleport Play];
				
				[ShipRTeleporting AnimFramesFrom:6 To:10.75 Step:.25];
				ShipRTeleporting->AnimFrameTime=19;
				
				//[ShipG MovetoX:TeleportTarget->Xpos Y:TeleportTarget->Ypos];
				[ShipR AnimFramesFrom:10.75 To:6 Step:-0.25];
				ShipR->AnimFrameTime=19;
				[ShipR RotateTo:0];
			
			} 
		CpuWait=0;}
	} else 	CpuWait++;
	//-(void)DrawTiledSpriteX:(float)Xpos Y:(float)Ypos W:(float)Wid H:(float)Hei TOX:(float)tox TOY:(float)toy TW:tw TH:th R:(float)Rot ;
	for (int i=0;i<astcount;i++){

		if (Asteroid[i]->AnimMoveSpeedX==0 && Asteroid[i]->AnimMoveSpeedY==0){
			float xx,yy;
			xx=arc4random();
			yy=arc4random();
			xx=((xx/ARC4RANDOM_MAX)*2.0f)-1.0f;
			yy=((yy/ARC4RANDOM_MAX)*3.0f)-1.5f;
			[Asteroid[i] AnimMovetoX:xx Y:yy S:0.004];
		}
		
		if (Asteroid[i]->Alp==0){ 
			Asteroid[i]->Xpos=arc4random();
			Asteroid[i]->Ypos=arc4random();
			Asteroid[i]->Xpos=((Asteroid[i]->Xpos/ARC4RANDOM_MAX)*1.6f)-0.8f;
			Asteroid[i]->Ypos=((Asteroid[i]->Ypos/ARC4RANDOM_MAX)*2.4f)-1.2f;
			//	sz=arc4random();
			//sz=((sz/ARC4RANDOM_MAX)*.2f)+.2f;
			float sz=.2;
			[Asteroid[i] SizeToW:0 H:0];
			[Asteroid[i] FadeTo:1];
			[Asteroid[i] AnimScaleX:sz/10 Y:sz/10 T:10];
		}
		
	}
	//Ships Collide
	if (([ShipG Intersects:ShipR TolW:1 TolH:1] && PUtype!=1) && (ShipR->Frame<1 || ShipR->Frame>3.99) ||([ShipG Intersects:ShipR TolW:2 TolH:2] && PUtype==1) && (ShipG->Frame<1 || ShipG->Frame>3.99))  {
		[shock Play];
		if (!(PUtype==3 && PUship==ShipR)) {
			[ShipR AnimFramesFrom:1 To:3.9 Step:.3];
			ShipR->AnimFrameTime=12;
		}
		if (!(PUtype==3 && PUship==ShipG)) {
			[ShipG AnimFramesFrom:1 To:3.9 Step:.3];
			ShipG->AnimFrameTime=12;
		}
		
		float GXmult,GYmult,Xmult,Ymult,xmove,ymove,spd;
		if (ShipG->AnimMoveEndX>ShipG->Xpos) GXmult=1; else GXmult=-1;
		if (ShipG->AnimMoveEndY>ShipG->Ypos) GYmult=1; else GYmult=-1;	
		xmove=ShipG->AnimMoveSpeedX*8;
		ymove=ShipG->AnimMoveSpeedY*8;
		spd=ShipG->AnimMoveSpeedX+ShipG->AnimMoveSpeedY*1.5;
		if (spd<.02) spd=.02;	
		if (xmove<.05 && xmove>0) xmove=.05;
		if (ymove<.05 && ymove>0) ymove=.05;
		if (ymove==0 && xmove==0) {ymove=.05;}
		
		
		float rx,ry,rs;
		
		if (ShipR->AnimMoveEndX<ShipR->Xpos) Xmult=-1; else Xmult=1;
		
		if (ShipR->AnimMoveEndY<ShipR->Ypos) Ymult=-1; else Ymult=1;	
		
		if (GXmult==Xmult && GYmult==Ymult) {Ymult=-Ymult;Xmult=-Xmult;}
		
		rx=ShipR->Xpos+xmove*GXmult;
		ry=ShipR->Ypos+ymove*GYmult;
		rs=spd;
		
		xmove=ShipR->AnimMoveSpeedX*8;
		ymove=ShipR->AnimMoveSpeedY*8;
		spd=ShipR->AnimMoveSpeedX+ShipR->AnimMoveSpeedY*1.5;
		
		
		if (spd<.02) spd=.02;	
		if (xmove<.05 && xmove>0) xmove=.05;
		if (ymove<.05 && ymove>0) ymove=.05;
		if (ymove==0 && xmove==0) {ymove=.05;}
		
		
		[ShipR AnimMovetoX:rx Y:ry S:rs];
		[ShipG AnimMovetoX:ShipG->Xpos+xmove*Xmult Y:ShipG->Ypos+ymove*Ymult S:spd];
		
		//ShipR->AnimMoveEndX=ShipR->Xpos;
		//ShipR->AnimMoveEndY=ShipR->Ypos;
		
		//ShipG->AnimMoveEndX=ShipG->Xpos;
		//ShipG->AnimMoveEndY=ShipG->Ypos;
		[sparks MovetoX:ShipG->Xpos-((ShipG->Xpos-ShipR->Xpos)/2) Y:ShipG->Ypos-((ShipG->Ypos-ShipR->Ypos)/2)];
		[sparks FadeTo:1];
		[sparks SizeToW:.5 H:.5];
		[sparks AnimFramesFrom:0 To:2 Step:1];
		sparks->AnimFrameTime=3; 
		if (ShipR->AnimMoveEndY<-1.3) CpuWait+=6666;
	}
	// Round Over?
	if (Ball->Ypos>=1.4 && Ball->Xpos>-GoalSize && Ball->Xpos<GoalSize) {
		[alarm Play];
		Rscore++;
		[self RoundInc];
		[self EndRound];
		GameState=3;
		Score-=100;
	}
	if (Ball->Ypos<=-1.4 && Ball->Xpos>-GoalSize && Ball->Xpos<GoalSize) {
		[alarm Play];
		Gscore++;
		Score+=100;
		[self RoundInc];
		[self EndRound];
		GameState=3;
	};	
	[FX FadeAX:10 Y:0 W:45 H:64];
	[FX Refresh];
};
// Updates the OpenGL view when the timer fires
- (void)drawView
{
	// Make sure that you are drawing to the current context
	[EAGLContext setCurrentContext:context];
	
	glBindFramebufferOES(GL_FRAMEBUFFER_OES, viewFramebuffer);
	glClear (GL_COLOR_BUFFER_BIT);

		
	[Backdrop DrawSprite];
	//[StarField->mysprite DrawTiledSpriteX:0 Y:0 W:3 H:3 TOX:0 TOY:0 TW:.7 TH:.7 R:0];
	//glColor4f(1, 1, 1, 0.5);
	[StarField->mysprite DrawTiledSpriteX:0 Y:0 W:5 H:5 TOX:0 TOY:0 TW:1 TH:1 R:StarField->Rot];
	[StarField DoAnimate];
	//glColor4f(1, 1, 1, 1);
	[FX->mysprite DrawSpriteX:-0.00 Y:0 W:3 H:3 R:0];
	//[myfont PrintTextX:0 Y:0 Z:0.3 Text:"hello World"];
	//[myfont MidPrintTextX:0 Y:.2 Z:0.3 Text:"hello World"];
	
	switch (ffstate)
	{
		case 0:
			ffstatetime+=.05;
			if (ffstatetime>1) ffstate=1;
			glColor4f(0, 0, 1, ffstatetime);
			break;
		case 1:
			glColor4f(0, 0, 1, 1);
			break;
		case 2:
			ffstatetime+=.05;
			if (ffstatetime>1) ffstate=1;
			glColor4f(1- ffstatetime, 0,  ffstatetime,1);
			break;
	
	}
	[ForceField DrawTiledSpriteX:-(1-GoalSize)/2-GoalSize Y:-1.45 W:.1 H:(1-GoalSize) TOX:0 TOY:ForcePos TW:.1 TH:.1 R:90];
	[ForceField DrawTiledSpriteX:(1-GoalSize)/2+GoalSize Y:-1.45 W:.1 H:(1-GoalSize) TOX:0 TOY:ForcePos TW:.1 TH:.1 R:90];
	[ForceField DrawTiledSpriteX:-(1-GoalSize)/2-GoalSize Y:1.45 W:.1 H:(1-GoalSize) TOX:0 TOY:ForcePos TW:.1 TH:.1 R:90];
	[ForceField DrawTiledSpriteX:(1-GoalSize)/2+GoalSize Y:1.45 W:.1 H:(1-GoalSize) TOX:0 TOY:ForcePos TW:.1 TH:.1 R:90];
	[ForceField DrawTiledSpriteX:-.95 Y:0 W:.1 H:3 TOX:0 TOY:ForcePos TW:.1 TH:.1 R:0];
	[ForceField DrawTiledSpriteX:.95 Y:0 W:.1 H:3 TOX:0 TOY:ForcePos TW:.1 TH:.1 R:180];
	glColor4f(1, 1, 1, 1);
	
	ForcePos+=.25;
	if (ForcePos>=1) ForcePos=0;
	
	if (Ball->AnimMoveSpeedX>0 ||Ball->AnimMoveSpeedY>0  )[FX FillX:(Ball->Xpos+1)*21+11 Y:(3-(Ball->Ypos+1.5))*21 W:2 H:2 R:0 G:255 B:255 A:200];
	if (ShipR->AnimMoveSpeedX>0 ||ShipR->AnimMoveSpeedY>0  )[FX FillX:(ShipR->Xpos+1)*21+10 Y:(3-(ShipR->Ypos+1.5))*21-1 W:3 H:3 R:255 G:0 B:0 A:200];
	if (ShipG->AnimMoveSpeedX>0 ||ShipG->AnimMoveSpeedY>0  )[FX FillX:(ShipG->Xpos+1)*21+10 Y:(3-(ShipG->Ypos+1.5))*21-1 W:3 H:3 R:0 G:255 B:0 A:200];
	
	
	
	[Sat1 DrawSprite];
	[Sat2 DrawSprite];
	[Sat3 DrawSprite];
	[Sat4 DrawSprite];
	for (int i=0;i<astcount;i++){
		if (ispaused) {
			[Asteroid[i] DrawOnly];
		} else {
			[Asteroid[i] DrawSprite];
			}
	}
	//[Asteroid[1] DrawSprite];
	[Powerups DrawSprite];
	if (PUtime>0){
		[PowerupsActive MovetoX:PUship->Xpos Y:PUship->Ypos];
		if (PUtype!=3) PowerupsActive->Rot=PUship->Rot;
		
	}
	
//	if (ispaused) 	[Ball DrawOnly]; else [Ball DrawSprite];

	//if (PUship==ShipG && PUtype==2) glColor4f(1,1, 1, .5);
	//if (PUship==ShipG && PUtype==3) glColor4f(.5, .5,.5, 1);

	
	
	
	if (ispaused) {
		
		[Ball DrawOnly];
		[ShipG DrawOnly];
		[ShipGTeleporting DrawOnly];
		[ShipR DrawOnly];
		[ShipRTeleporting DrawOnly];
		
	} else {
		[Ball DrawSprite];
	[ShipG DrawSprite];
	[ShipGTeleporting DrawSprite];
	[ShipR DrawSprite];
	[ShipRTeleporting DrawSprite];
		
	};
	
	
	

	

	if (PUtime>0){
		[PowerupsActive DrawSprite];
	}
	[TeleportTarget DrawSprite];
	[TouchSpot DrawSprite];
	[MoveTarget DrawSprite];
	char ch[100];
	//sprintf(ch,"GX:%f GY:%f GZ:%f",AccelX,AccelY,AccelZ);
	
	//[myfont PrintTextX:-1 Y:-1.3 Z:0.07 Text:ch];
	//sprintf(ch,"X:%f Y:%f Z:%f ",GravX,GravY,GravZ);
	glColor4f(0, 0, 0, 0.3);
//-(void)DrawSolidX:(float)Xpos Y:(float)Ypos W:(float)Wid H:(float)Hei R:(float)Rot 
	[myfont DrawSolidX:0 Y:1.5 W:2 H:.25 R:0];
	glColor4f(1, 1, 1, 1);

	//sprintf(ch,"X:%f ",ShipG->Rot);
	//[myfont PrintTextX:-1 Y:-1.2 Z:0.07 Text:ch];
	
	sprintf(ch,"Score: %d",Score);	
	[myfont PrintTextX:-.9 Y:1.45 Z:0.07 Text:ch];
	sprintf(ch,"Game: %d: %d-%d",GameNum,Gscore,Rscore);
	
	[myfont PrintTextX:.4 Y:1.45 Z:0.07 Text:ch];
	sprintf(ch,"Time: %d",RoundTime/20);		
	if (RoundTime/20<10){

	[myfont MidPrintTextX:0 Y:0 Z:0.3 Text:ch];
	}else{
			
		[myfont MidPrintTextX:0 Y:1.45 Z:0.07 Text:ch];

	}
	
	
	if (PUtextSize>0){
		char txt[10];
		switch (PUtype) {
		case 1: 
				strcpy(txt,"Mega");
				glColor4f(1, 1,0, 1-(PUtextSize));
				break;
		case 2:
			strcpy(txt,"Turbo");
				glColor4f(0, 0, 1, 1-(PUtextSize));
				break;
		case 3:
			strcpy(txt,"Shield");
				glColor4f(1, 0, 1, 1-(PUtextSize));
				break;
		case 4:
			strcpy(txt,"Magnet");
				glColor4f(0, .5, 1, 1-(PUtextSize));
			break;
		}
		[burst DrawAniSpriteX:Powerups->Xpos  Y:Powerups->Ypos W:PUtextSize*3 H:PUtextSize*3 R:0 F:10 Flip:0];
		[myfont MidPrintTextX:Powerups->Xpos Y:Powerups->Ypos Z:PUtextSize Text:txt];
		glColor4f(1, 1, 1, 1);
		PUtextSize+=.1;
		if (PUtextSize>=1) PUtextSize=0;
	
	}
	[sparks DrawSprite];
	// do the fx
		//	[mysprite DrawSpriteX:-0.5 Y:-0.5 W:1 H:1 R:0];

	//-(void)PrintTextX:(float)x Y:(float)y Z:(float)z Text:(char *)textline

	
	//

	
	
	
	if (ispaused) {
		[self drawPaused];
		
	} else {
	glColor4f(1, 1, 1, 0.3);
		[MenuTarget DrawAniSpriteX:-.8 Y:-1.45 W:.4 H:.15 R:0 F:15 Flip:0];
	glColor4f(1, 1, 1, 0.6);
		[myfont MidPrintTextX:-.8 Y:-1.45 Z:0.1 Text:"Pause"];
	glColor4f(1, 1, 1, 1);
	}
	
	glBindRenderbufferOES(GL_RENDERBUFFER_OES, viewRenderbuffer);
	[context presentRenderbuffer:GL_RENDERBUFFER_OES];
}

-(void)touchesMoved:(NSSet *)touches withEvent:(UIEvent *)event {
	[TouchSpot AnimFade:.1];
	UITouch *touch = [[event allTouches] anyObject];
	CGPoint location = [touch locationInView:touch.view];
	//CGPoint xLocation = CGPointMake(location.x,racquet_yellow.center.y);
	//tx=(tx-TouchLastX);
	//ty=(ty-TouchLastY);
	TouchLastX=location.x*2/self.window.bounds.size.width-1;
	TouchLastY=(1.5-location.y*3/self.window.bounds.size.height);


	/*
	 float tx,ty;
	 tx=location.x*2/self.window.bounds.size.width-1;
	 ty=(1.5-location.y*3/self.window.bounds.size.height);
	 
	 tx=(tx-TouchStartX);
	 ty=(ty-TouchStartY);

	 if (GameState==2 && (tx<-.1 || tx>.1 || ty<-.1 || ty>.1 )){
		if (tx<=.1 && tx>=-.1) tx=0;
		if (tx>.1) tx-=.1;
		if (tx<-.1) tx+=.1;
		
		if (ty<=.1 && ty>=-.1) ty=0;
		if (ty>.1) ty-=.1;
		if (ty<-.1) ty+=.1;
	//	float f1=abs(ty*100);
	//	float f2=abs(tx*100);
		
	//	float f1=(ty*100);
	//	float f2=-(tx*100);
		
		float myrot=atan(-tx/ty)*180/3.14;
		
		if (ty<0) myrot+=180;
		if (myrot<0) myrot+=360;
		if (ShipG->AnimMoveSpeedX>0 ||ShipG->AnimMoveSpeedY>0  ){
			tx=ShipG->Xpos+tx;
			ty=ShipG->Ypos+ty;
			
		}
		else{
			tx=ShipG->AnimMoveEndX+tx;
			ty=ShipG->AnimMoveEndY+ty;
		}
		
		
	if (ShipR->Frame<1 || ShipR->Frame>3) { 
		//Move Player
		//[ShipG RotateTo:myrot];
		[ShipG AnimRotateTo:myrot S:5];
		//if (ty<ShipG->Ypos) [ShipG AnimRotateTo:180 S:5]; else [ShipG AnimRotateTo:0 S:5];
		[MoveTarget MovetoX:tx Y:ty];
		[MoveTarget SizeToW:1 H:1];
		//[MoveTarget AnimScaleX:-.1 Y:-.1 T:8];
		[MoveTarget SizeToW:.2 H:.2];
		[MoveTarget FadeTo:.8];
		[MoveTarget AnimFade:-.2];
		float spd;
		if (PUtype==2 && PUship==ShipG) spd=.07; else spd=.05;
		[ShipG AnimMovetoX:tx Y:ty S:spd];

	}
		TouchLastX=location.x*2/self.window.bounds.size.width-1;
		TouchLastY=(1.5-location.y*3/self.window.bounds.size.height);
	}
	 */

}
- (void)touchesEnded:(NSSet *)touches withEvent:(UIEvent *)event {

	if (!ispaused){
	[TouchSpot AnimFade:-.1];
	UITouch *touch = [[event allTouches] anyObject];
	CGPoint location = [touch locationInView:touch.view];
	//CGPoint xLocation = CGPointMake(location.x,racquet_yellow.center.y);
	float tx,ty;
	tx=location.x*2/self.window.bounds.size.width-1;
	ty=(1.5-location.y*3/self.window.bounds.size.height);
	tx-=TouchStartX;
	ty-=TouchStartY;
	
	 if (GameState==2 && tx>-.1 && tx<.1 && ty>-.1 && ty<.1 ){

		tx=location.x*2/self.window.bounds.size.width-1;
		ty=(1.5-location.y*3/self.window.bounds.size.height);
		if (TeleportTarget->Alp>0 && [TeleportTarget IsTouchedX:tx Y:ty])
		{
			// Teleport Player
			[teleport Play];
			[ShipGTeleporting CopyAttributes:ShipG];
			[ShipGTeleporting AnimFramesFrom:6 To:10.75 Step:.25];
			ShipGTeleporting->AnimFrameTime=19;
			
			[ShipG MovetoX:TeleportTarget->Xpos Y:TeleportTarget->Ypos];
			[ShipG AnimFramesFrom:10.75 To:6 Step:-0.25];
			ShipG->AnimFrameTime=19;
			[ShipG RotateTo:180];
			[TeleportTarget FadeTo:0];
			
		}
		else {
			if (TouchTime>30 && [Backdrop IsTouchedX:tx Y:ty ObjX:-.8 ObjY:-1.45 ObjW:.4 ObjH:.15]){
			//[MenuTarget DrawSpriteX:-.8 Y:-1.3 W:.4 H:.15 R:0];
					ispaused=YES;
				
			}
			else if ((ShipG->Frame<1 || ShipG->Frame>3.999)){ 
				//Move Player
				
				float txa=tx-ShipG->Xpos;
				float tya=ty-ShipG->Ypos;
				float myrot=atan(-txa/tya)*180/3.14;
				
				if (tya<0) myrot+=180;
				if (myrot<0) myrot+=360;
				
				[ShipG AnimRotateTo:myrot S:5];
				[MoveTarget MovetoX:tx Y:ty];
				[MoveTarget SizeToW:1 H:1];
				[MoveTarget AnimScaleX:-.1 Y:-.1 T:8];
				[MoveTarget FadeTo:.8];
				[MoveTarget AnimFade:-.05];
				float spd;
				if (PUtype==2 && PUship==ShipG) spd=.07; else spd=.05;
				[ShipG AnimMovetoX:tx Y:ty S:spd];
			}
			
		}
	}
	}
	TouchTime=0;
}
- (void)touchesBegan:(NSSet *)touches withEvent:(UIEvent *)event {
	TouchTime=1;
	UITouch *touch = [[event allTouches] anyObject];
	CGPoint location = [touch locationInView:touch.view];
	//CGPoint xLocation = CGPointMake(location.x,racquet_yellow.center.y);
	float tx,ty;
	tx=location.x*2/self.window.bounds.size.width-1;
	ty=(1.5-location.y*3/self.window.bounds.size.height);
	[TouchSpot MovetoX:tx Y:ty];
	TouchStartX=tx;
	TouchStartY=ty;
	TouchLastX=tx;
	TouchLastY=ty;

	if (ispaused){
		if ([Backdrop IsTouchedX:tx Y:ty ObjX:0 ObjY:-.5 ObjW:1.8 ObjH:.3]){
			ispaused=NO;
		}
		if ([Backdrop IsTouchedX:tx Y:ty ObjX:.5 ObjY:-1 ObjW:.8 ObjH:.3]){
			//TouchGame
			if (AccelXzero<-900){
				AccelXzero=AccelX;
				AccelYzero=AccelY;
			}else{
				AccelXzero=-999;
				
			};
			}
		if ([Backdrop IsTouchedX:tx Y:ty ObjX:-.5 ObjY:-1 ObjW:.8 ObjH:.3]){
			ispaused=NO;
			Rscore=99;
			[self RoundInc];
			[self EndRound];
			GameState=3;
		}
	}else{
	switch (GameState)
	{
		case 1:
		{
			BOOL NewGame=NO;
			/*
			[MenuTarget DrawSpriteX:-.5 Y:-.5 W:.8 H:.3 R:0];
			[MenuTarget DrawSpriteX:.5 Y:-.5 W:.8 H:.3 R:0];
			
			[MenuTarget DrawSpriteX:-.5 Y:-1 W:.8 H:.3 R:0];
			[MenuTarget DrawSpriteX:.5 Y:-1 W:.8 H:.3 R:0];
			glColor4f(1, 1, 1, 1);	
			
			[myfont MidPrintTextX:-.5 Y:-.45 Z:0.1 Text:"Start"];
			[myfont MidPrintTextX:-.5 Y:-.55 Z:0.1 Text:"Touch Game"];
			[myfont MidPrintTextX:.5 Y:-.45 Z:0.1 Text:"Start"];
			[myfont MidPrintTextX:.5 Y:-.55 Z:0.1 Text:"Tilt Game"];
			
			 -(BOOL)IsTouchedX:(float)x Y:(float)y ObjX:(float)ObjX ObjY:(float)ObjY ObjW:(float)ObjW ObjH:(float)ObjH;
			 */
		
			if ([Backdrop IsTouchedX:tx Y:ty ObjX:.5 ObjY:-.5 ObjW:.8 ObjH:.3]){
			//TouchGame
				AccelXzero=AccelX;
				AccelYzero=AccelY;
				NewGame=YES;
			}
			if ([Backdrop IsTouchedX:tx Y:ty ObjX:.5 ObjY:-1 ObjW:.8 ObjH:.3]){
				//[[UIApplication sharedApplication] terminate];
				//exit(0);
				GameStateTime=3;
				GameState=4;
			}
			if ([Backdrop IsTouchedX:tx Y:ty ObjX:-.5 ObjY:-.5 ObjW:.8 ObjH:.3]){
				//TouchGame
				
				AccelXzero=-999;
				NewGame=YES;
			}
			if ([Backdrop IsTouchedX:tx Y:ty ObjX:-.5 ObjY:-1 ObjW:.8 ObjH:.3]){
				GameStateTime=0;
				GameState=4;
			}
			if (NewGame){
			GameState=3;
			RoundNum=0;
			GameNum=1;
			Gscore=0;
			Score=0;
	
			AiLevel=1;
			Rscore=0;
			[self RoundInc];
				[self NewRound:NO];[music PlayLooping];
			//[self EndRound];
			GameStateTime=0;
				[ambient Stop];
				//[music LoadSound:@"FluidRetroTension" Ext:@"mp3"];
			//[music Play];
				[music PlayLooping];
				int rnback=1+(arc4random() %8);
				[Backdrop  LoadPvrSprite:[NSString stringWithFormat:@"BACK%d",rnback]];
				[Backdrop AnimRotate:.2];
				[Backdrop SizeToW:4 H:4];
				[Backdrop FadeTo:0];
				[Backdrop AnimFade:.05];
			}
			break;
		}
		case 2:
		
	
			break;
		case 3:
			//GameState=2;
			break;
		case 4:
			GameStateTime++;
		default:
			break;
	}}

}
- (void)accelerometer:(UIAccelerometer*)accelerometer didAccelerate:(UIAcceleration*)acceleration
{
	if (AccelXzero>-999){
	AccelX= acceleration.x * kFilteringFactor + (AccelX * (1.0 - kFilteringFactor));
	AccelY= acceleration.y * kFilteringFactor + (AccelY * (1.0 - kFilteringFactor));

	float xx=AccelX-AccelXzero;
	float yy=AccelY-AccelYzero;
		
		if (xx>.20) AccelXzero+=(xx-.20);
		if (xx<-.20) AccelXzero+=(xx+.20);
		if (yy>.20) AccelYzero+=(yy-.20);
		if (yy<-.20) AccelYzero+=(yy+.20);
		

		if (xx<=.020 && xx>=-.020) xx=0;
	if (xx>.020) xx-=.020;
	if (xx<-.020) xx+=.020;
	
	if (yy<=.020 && yy>=-.020) yy=0;
	if (yy>.020) yy-=.020;
	if (yy<-.020) yy+=.020;
		//xx*=2;
	//	yy*=2;
	float tx,ty;
		
		float txa=xx;
		float tya=yy;
		float myrot=atan(-txa/tya)*180/3.14;
		
		if (tya<0) myrot+=180;
		if (myrot<0) myrot+=360;
		
		
		
	tx=ShipG->Xpos+xx;
	ty=ShipG->Ypos+yy;
	if ((ShipG->Frame<1 || ShipG->Frame>3.999) && (xx!=0 || yy!=0) && GameState==2){ 
		//Move Player
		[ShipG AnimRotateTo:myrot S:5];
		[MoveTarget MovetoX:tx Y:ty];
		[MoveTarget SizeToW:1 H:1];
		//[MoveTarget AnimScaleX:-.1 Y:-.1 T:8];
		[MoveTarget SizeToW:.2 H:.2];
		[MoveTarget FadeTo:.8];
		[MoveTarget AnimFade:-.2];
		float spd;
		if (PUtype==2 && PUship==ShipG) spd=.07; else spd=.05;
		[ShipG AnimMovetoX:tx Y:ty S:spd];
	}
	
	}
	
	//Use a basic low-pass filter to only keep the gravity in the accelerometer values
	//GravX = acceleration.x * kFilteringFactor + (GravX * (1.0 - kFilteringFactor));
	//GravY = acceleration.y * kFilteringFactor + (GravY * (1.0 - kFilteringFactor));
	//GravZ = acceleration.z * kFilteringFactor + (GravZ * (1.0 - kFilteringFactor));
	//AccelX=acceleration.x-((acceleration.x * kFilteringFactor)+(AccelX*(1.0-kFilteringFactor)));
	//AccelY=acceleration.y-((acceleration.y * kFilteringFactor)+(AccelY*(1.0-kFilteringFactor)));
	//AccelZ=acceleration.z-((acceleration.z * kFilteringFactor)+(AccelZ*(1.0-kFilteringFactor)));
	//GravX=floorf(((double)arc4random()/ARC4RANDOM_MAX)*2.0f)-1.0f;
}
// Stop animating and release resources when they are no longer needed.
- (void)dealloc
{
	[self stopAnimation];
	
	if([EAGLContext currentContext] == context) {
		[EAGLContext setCurrentContext:nil];
	}
	
	[context release];
	context = nil;
	
	[StarField release];
	[TouchSpot release];
	[MoveTarget release];
	[TeleportTarget release];
	[Ball release];
	[ShipG release];
	[ShipGTeleporting release];
	[ShipR release];
	[ShipRTeleporting release];
	[Sat1 release];
	[Sat2 release];
	[Sat3 release];
	[Sat4 release];
	[sparks release];
	//[burst release]; // we're using a shared sprite, so dont't release
	[MenuTarget release];
	[asteroidball release];
	[asteroidship release];
	[powerup release];
	[Backdrop release];
	[Powerups release];
	[PowerupsActive release];
	[FX release];
	[bounce release];
	[shock release];
	[teleport release];
	[alarm release];
	[music release];
	[ambient release];
	[PUship release];
	[myfont release];
	[animationTimer release];

//	[settings release];
	[super dealloc];
}
/*-(id<GLGravityViewDelegate>)delegate
{
	return delegate;
}

// Update the delegate, and if it needs a -setupView: call, set our internal flag so that it will be called.
-(void)setDelegate:(id<GLGravityViewDelegate>)d
{
	delegate = d;
	delegateSetup = ![delegate respondsToSelector:@selector(setupView:)];
}
*/
// If our view is resized, we'll be asked to layout subviews.
// This is the perfect opportunity to also update the framebuffer so that it is
// the same size as our display area.
@end
