#include "sprite.h"
#include "globals.h"
#include "BasicFileIO.h"

void sprite::settexture(char * file,char * path)
{
	char t[1024];
	strcpy(t,"");

	if (strcmp(path,"")!=0)
	{
		strcat2(t,path,1024);
		
	}
	strcat2(t,file,1024);

	glEnable(GL_TEXTURE_2D);
	pngInfo info;
	if (FileExists(t))
		{
		texture =(pngBind(t, -1, PNG_ALPHA, &info, GL_CLAMP, GL_LINEAR, GL_LINEAR));
		InUse=TRUE;
		}
	else
		hMsgLog.MsgBox("Sprite:Texture not found",t);
	//sprite::texturenum =t;PNG_NOMIPMAP

}

void sprite::settiletexture(char * file,char * path)
{

	char t[1024];
	strcpy(t,"");

	if (strcmp(path,"")!=0)
	{
		strcat2(t,path,1024);
		
	}
	strcat2(t,file,1024);

	glEnable(GL_TEXTURE_2D);
	pngInfo info;
	if (FileExists(t))
		{
		InUse=TRUE;
		texture =(pngBind(t, -1, PNG_ALPHA, &info, GL_REPEAT, GL_LINEAR, GL_LINEAR));
		}
		else
		hMsgLog.MsgBox("Sprite:Texture not found",t);

	//sprite::texturenum =t;PNG_NOMIPMAP

}


sprite::sprite(){
TileX=1;
TileY=1;
//texture = new GLuint;
InUse=FALSE;
}
sprite::~sprite(){
if (InUse==TRUE)
	glDeleteTextures(1,&texture);
}

void sprite::draw(int x,int y, int w,int h,int r,int framenum)
{ 

	/*
	char ch[100];
	sprintf(ch,"%i",framenum);
	MessageBox(NULL,ch,ch,MB_OK);
	*/
	if (framenum<0 || framenum>frames)
		framenum=0;


	float xpos=(int)(framenum%TileX);
	float ypos=(int)(framenum/TileX);

	float xwidth=1/(float)TileX;
	float ywidth=1/(float)TileY;

	

	glPushMatrix();										// Store The Projection Matrix
	glTranslated(x,y,1.0f);
	glEnable(GL_BLEND);		// Turn Blending On
	glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);		// Blending Function For Translucency Based On Source Alpha Value ( NEW 
	glRotatef((float)r,0.0f,0.0f,1.0f);
	
	glBindTexture(GL_TEXTURE_2D, texture);

	glBegin(GL_QUADS);
	glTexCoord2f((xpos*xwidth)+.001,(ypos*ywidth)+.001); glVertex3f(-(w/2), -(h/2),  0.0f);
	glTexCoord2f((xpos*xwidth)+.001, ((ypos+1)*ywidth)-.001); glVertex3f(  -(w/2),(h/2),  0.0f);
	glTexCoord2f(((xpos+1)*xwidth)-.001,((ypos+1)*ywidth)-.001); glVertex3f( (w/2),  (h/2),  0.0f);
	glTexCoord2f(((xpos+1)*xwidth)-.001,(ypos*ywidth)+.001); glVertex3f((w/2),-(h/2),0.0f);
	/*
	glTexCoord2f(0.0f, 0.0f); glVertex3f(-(w/2), -(h/2),  0.0f);
	glTexCoord2f(0.0f, 1.0f); glVertex3f(  -(w/2),(h/2),  0.0f);
	glTexCoord2f(1.0f, 1.0f); glVertex3f( (w/2),  (h/2),  0.0f);
	glTexCoord2f(1.0f, 0.0f); glVertex3f((w/2),-(h/2),0.0f);
	*/
	  
	glEnd();
	glDisable(GL_BLEND);		// Disable Blending
	glPopMatrix();


}

void sprite::drawtile (float xt,float yt,float wt,float ht,int x,int y, int w,int h,int r,int framenum)
{ 



	if (framenum<0 || framenum>frames)
	{
		framenum=0;
		
	}

	float TX=TileX;
	float TY=TileY;
	float xpos=(int)(framenum%TileX);
	float ypos=(int)(framenum/TileX);
	wt=wt/TX;
	ht=ht/TY;

	xt=(xt/TX);xt+=wt*xpos;
	yt=(yt/TY);yt+=ht*ypos;
	
	



	glPushMatrix();										// Store The Projection Matrix
	glTranslated(x,y,1.0f);
	glEnable(GL_BLEND);		// Turn Blending On
	glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);		// Blending Function For Translucency Based On Source Alpha Value ( NEW 
	glRotatef(r,0.0f,0.0f,1.0f);
	
	glBindTexture(GL_TEXTURE_2D, texture);

	glBegin(GL_QUADS); 
	
	glTexCoord2f(xt, yt); glVertex3f(-(w/2), -(h/2),  0.0f);
	glTexCoord2f(xt, yt+ht); glVertex3f(  -(w/2),(h/2),  0.0f);
	glTexCoord2f(xt+wt, yt+ht); glVertex3f( (w/2),  (h/2),  0.0f);
	glTexCoord2f(xt+wt, yt); glVertex3f((w/2),-(h/2),0.0f);
	glEnd();
	glDisable(GL_BLEND);		// Disable Blending
	glPopMatrix();


}


void sprite::drawb(int x,int y, int w,int h,int r)
{ 
	glPushMatrix();										// Store The Projection Matrix
	glTranslated(x,y,1.0f);
	glEnable(GL_BLEND);		// Turn Blending On
	glBlendFunc(GL_SRC_ALPHA,GL_ONE);		// Blending Function For Translucency Based On Source Alpha Value ( NEW 
	glRotatef(r,0.0f,0.0f,1.0f);
	
	glBindTexture(GL_TEXTURE_2D, texture);

	glBegin(GL_QUADS);
	glTexCoord2f(0.0f, 0.0f); glVertex3f(-(w/2), -(h/2),  0.0f);
	glTexCoord2f(0.0f, 1.0f); glVertex3f(  -(w/2),(h/2),  0.0f);
	glTexCoord2f(1.0f, 1.0f); glVertex3f( (w/2),  (h/2),  0.0f);
	glTexCoord2f(1.0f, 0.0f); glVertex3f((w/2),-(h/2),0.0f);
	glEnd();
	glDisable(GL_BLEND);		// Disable Blending
	glPopMatrix();


}

