//
//  IPCoreSpriteObj.h
//  GLSprite
//
//  Created by David Austin on 09/05/2009.
//  Copyright 2009 David Austin Roses Ltd. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "IPCoreSprite.h"

@interface IPCoreSpriteObj : NSObject {
@public
	bool LoadedSprite;
	IPCoreSprite *mysprite;
	float Xpos;
	float Ypos;
	float Wid;
	float Hei;
	float Rot;
	float Alp;
	int FlipMe;
	float Frame;
	int Frames;
	float AnimRotating;
	float AnimRotatingTime;
	float AnimScalingX;
	float AnimScalingY;
	float AnimScalingTime;
	float AnimFading;
	float AnimFrameStep;
	float AnimFrameFrom;
	float AnimFrameTo;
	int AnimFrameTime;
	float AnimMoveSpeedX;
	float AnimMoveSpeedY;
	float AnimMoveEndX;
	float AnimMoveEndY;
@private
	}
-(void)LoadSprite:(NSString *)spritename;
-(void)LoadPvrSprite:(NSString *)spritename;
-(void)DrawSprite;
-(void)DoAnimate;
-(void)DefineTileX:(int)xsize Y:(int)Ysize;
-(BOOL)IsTouchedX:(float)x Y:(float)y ObjX:(float)ObjX ObjY:(float)ObjY ObjW:(float)ObjW ObjH:(float)ObjH;
-(BOOL)IsTouchedX:(float)x Y:(float)y;
-(void)MovetoX:(float)x Y:(float)y;
-(void)MovetoX:(float)x;
-(void)MovetoY:(float)y;
-(void)SizeToW:(float)w H:(float)h;
-(void)ResetSize;
-(void)RotateTo:(float)r;
-(void)FadeTo:(float)a;
-(void)FrameTo:(float)f;
-(void)AnimRotate:(float)r; 
-(void)AnimRotateTo:(float)r S:(float)speed;
-(void)AnimFade:(float)a;
-(void)AnimScaleX:(float)x Y:(float)y T:(float)ti;
-(void)AnimFramesFrom:(float)f To:(float)t Step:(float)s;
-(void)AnimMovetoX:(float)x Y:(float)y S:(float)spd;
-(BOOL)Intersects:(IPCoreSpriteObj *)sprite2 TolW:(float)tolw TolH:(float)tolh;
-(void)ShareSprite:(IPCoreSpriteObj *)sprite2;
-(void)CopyAttributes:(IPCoreSpriteObj *)sprite2;
-(void)CopyAnim:(IPCoreSpriteObj *)sprite2;
-(void)DrawOnly;
@end
