//
//  IPCoreSprite.m
//  GLSprite
//
//  Created by David Austin on 09/05/2009.
//  Copyright 2009 David Austin Roses Ltd. All rights reserved.
//

#import "IPCoreSprite.h"
#define PVR_TEXTURE_FLAG_TYPE_MASK	0xff

@implementation IPCoreSprite
const GLfloat BasicVertices[] = {
-0.5f, -0.5f,
-0.5f, 0.5f,
0.5f,  -0.5f,
0.5f,  0.5f,};
const GLfloat BasicVerticesXflip[] = {
0.5f, -0.5f,
0.5f, 0.5f,
-0.5f,  -0.5f,
-0.5f,  0.5f,};
const GLshort BasicCoords[] = {

0,1,
0, 0,
1, 1,
1, 0,};

//static char gPVRTexIdentifier[4] = "PVR!";

enum
{
	kPVRTextureFlagTypePVRTC_2 = 24,
	kPVRTextureFlagTypePVRTC_4
};

typedef struct _PVRTexHeader
	{
		uint32_t headerLength;
		uint32_t height;
		uint32_t width;
		uint32_t numMipmaps;
		uint32_t flags;
		uint32_t dataLength;
		uint32_t bpp;
		uint32_t bitmaskRed;
		uint32_t bitmaskGreen;
		uint32_t bitmaskBlue;
		uint32_t bitmaskAlpha;
		uint32_t pvrTag;
		uint32_t numSurfs;
	} PVRTexHeader;



-(void)LoadPvrSprite:(NSString *)spritename{
	NSMutableArray *_imageData;
	GLenum _internalFormat;
	NSData *data = [NSData dataWithContentsOfFile:[[NSBundle mainBundle] pathForResource:spritename ofType:@"pvr"]];
	_internalFormat = GL_COMPRESSED_RGBA_PVRTC_4BPPV1_IMG;
	_imageData = [[NSMutableArray alloc] initWithCapacity:10];
	//BOOL success = FALSE;
	PVRTexHeader *header = NULL;
	uint32_t flags, pvrTag;
	uint32_t dataLength = 0, dataOffset = 0, dataSize = 0;
	uint32_t blockSize = 0, widthBlocks = 0, heightBlocks = 0;
	uint32_t width = 0, height = 0, bpp = 4;
	uint8_t *bytes = NULL;
	uint32_t formatFlags;
	
	header = (PVRTexHeader *)[data bytes];
	
	pvrTag = CFSwapInt32LittleToHost(header->pvrTag);
	
	//if (gPVRTexIdentifier[0] != ((pvrTag >>  0) & 0xff) ||
	//	gPVRTexIdentifier[1] != ((pvrTag >>  8) & 0xff) ||
	//	gPVRTexIdentifier[2] != ((pvrTag >> 16) & 0xff) ||
//		gPVRTexIdentifier[3] != ((pvrTag >> 24) & 0xff))
//	{
//		return FALSE;
//	}
	
	flags = CFSwapInt32LittleToHost(header->flags);
	formatFlags = flags & PVR_TEXTURE_FLAG_TYPE_MASK;
	formatFlags = kPVRTextureFlagTypePVRTC_2;
	if (formatFlags == kPVRTextureFlagTypePVRTC_4 || formatFlags == kPVRTextureFlagTypePVRTC_2)
	{
		[_imageData removeAllObjects];
		
		if (formatFlags == kPVRTextureFlagTypePVRTC_4)
			_internalFormat = GL_COMPRESSED_RGBA_PVRTC_4BPPV1_IMG;
		else if (formatFlags == kPVRTextureFlagTypePVRTC_2)
			_internalFormat = GL_COMPRESSED_RGBA_PVRTC_2BPPV1_IMG;
		
		ResX =width= CFSwapInt32LittleToHost(header->width);
		ResY = height= CFSwapInt32LittleToHost(header->height);
	//	=ResX;
	//	height=ResY;
		//if (CFSwapInt32LittleToHost(header->bitmaskAlpha))
		//	_hasAlpha = TRUE;
		//else
		//	_hasAlpha = FALSE;
		
		dataLength = CFSwapInt32LittleToHost(header->dataLength);
		
		bytes = ((uint8_t *)[data bytes]) + sizeof(PVRTexHeader);
		
		// Calculate the data size for each texture level and respect the minimum number of blocks
		while (dataOffset < dataLength)
		{
			if (formatFlags == kPVRTextureFlagTypePVRTC_4)
			{
				blockSize = 4 * 4; // Pixel by pixel block size for 4bpp
				widthBlocks = width / 4;
				heightBlocks = height / 4;
				bpp = 4;
			}
			else
			{
				blockSize = 8 * 4; // Pixel by pixel block size for 2bpp
				widthBlocks = width / 8;
				heightBlocks = height / 4;
				bpp = 2;
			}
			
			// Clamp to minimum number of blocks
			if (widthBlocks < 2)
				widthBlocks = 2;
			if (heightBlocks < 2)
				heightBlocks = 2;
			
			dataSize = widthBlocks * heightBlocks * ((blockSize  * bpp) / 8);
			
			[_imageData addObject:[NSData dataWithBytes:bytes+dataOffset length:dataSize]];
			
			dataOffset += dataSize;
			
			width = MAX(width >> 1, 1);
			height = MAX(height >> 1, 1);
		}
		int i=0;
		//	for (int i=0; i < [_imageData count]; i++)
		//	{
		//	data = [_imageData objectAtIndex:i];
		//	glCompressedTexImage2D(GL_TEXTURE_2D, i, _internalFormat, ResX, ResY, 0, [data length], [data bytes]);
		glGenTextures(1, &spriteTexture);
		// Bind the texture name. 
		glBindTexture(GL_TEXTURE_2D, spriteTexture);
		// Speidfy a 2D texture image, provideing the a pointer to the image data in memory
		//glTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA, width, height, 0, GL_RGBA, GL_UNSIGNED_BYTE, spriteData);
		// Release the image data
		data = [_imageData objectAtIndex:i];
		glCompressedTexImage2D(GL_TEXTURE_2D, i, _internalFormat, ResX, ResY, 0, [data length], [data bytes]);
		
		//free(spriteData);
		// Set the texture parameters to use a minifying filter and a linear filer (weighted average)
		
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);	// Set Texture Max Filter
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);	// Set Texture Min Filter
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S,GL_REPEAT);
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T,GL_REPEAT);
		// Enable use of the texture
		glEnable(GL_TEXTURE_2D);
		inuse=YES;
		//success = TRUE;
	}
	//int width = _width;
	//int height = _height;
	//NSData *data;
	//GLenum err;
	
	//if ([_imageData count] > 0)
	//{
		//if (_name != 0)
		//	glDeleteTextures(1, &_name);
		
	//	glGenTextures(1, &spriteTexture);
	//	glBindTexture(GL_TEXTURE_2D, spriteTexture);
	//}
	
	
	 
	
	//	err = glGetError();
	//	if (err != GL_NO_ERROR)
	//	{
	//		NSLog(@"Error uploading compressed texture level: %d. glError: 0x%04X", i, err);
		//	return FALSE;
	//	}
		
		//width = MAX(width >> 1, 1);
	//	height = MAX(height >> 1, 1);
	//}
	
		
	
	
	[_imageData removeAllObjects];
	[_imageData release];
	//return TRUE;
	

}

-(void)LoadSprite:(NSString *)spritename
{
	TileX=1;
	TileY=1;
	if (inuse) glDeleteTextures(1, &spriteTexture);
	CGImageRef spriteImage;
	CGContextRef spriteContext;
	GLubyte *spriteData;
	size_t	width, height;
	// Creates a Core Graphics image from an image file
	spriteImage = [UIImage imageNamed:spritename].CGImage;
	// Get the width and height of the image
	width = CGImageGetWidth(spriteImage);
	height = CGImageGetHeight(spriteImage);
	ResX=width;
	ResY=height;
	// Texture dimensions must be a power of 2. If you write an application that allows users to supply an image,
	// you'll want to add code that checks the dimensions and takes appropriate action if they are not a power of 2.
	
	if(spriteImage) {
		// Allocated memory needed for the bitmap context
		spriteData = (GLubyte *) malloc(width * height * 4);
		// Uses the bitmatp creation function provided by the Core Graphics framework. 
		
		spriteContext = CGBitmapContextCreate(spriteData, width, height, 8, width * 4, CGImageGetColorSpace(spriteImage),kCGImageAlphaPremultipliedLast);
		// After you create the context, you can draw the sprite image to the context.
		CGContextClearRect(spriteContext,CGRectMake(0.0, 0.0, (CGFloat)width, (CGFloat)height));
		CGContextDrawImage(spriteContext, CGRectMake(0.0, 0.0, (CGFloat)width, (CGFloat)height), spriteImage);
		// You don't need the context at this point, so you need to release it to avoid memory leaks.
		CGContextRelease(spriteContext);
		
		// Use OpenGL ES to generate a name for the texture.
		glGenTextures(1, &spriteTexture);
		// Bind the texture name. 
		glBindTexture(GL_TEXTURE_2D, spriteTexture);
		// Speidfy a 2D texture image, provideing the a pointer to the image data in memory
		
		
		glTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA, width, height, 0,GL_RGBA, GL_UNSIGNED_BYTE, spriteData);
		// Release the image data
		
		free(spriteData);
		// Set the texture parameters to use a minifying filter and a linear filer (weighted average)
		
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);	// Set Texture Max Filter
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);	// Set Texture Min Filter
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S,GL_REPEAT);
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T,GL_REPEAT);
		// Enable use of the texture
		glEnable(GL_TEXTURE_2D);
		inuse=YES;
	}
}

-(void)DrawTiledSpriteX:(float)Xpos Y:(float)Ypos W:(float)Wid H:(float)Hei TOX:(float)tox TOY:(float)toy TW:(float)tw TH:(float)th R:(float)Rot 
	{
		glBindTexture(GL_TEXTURE_2D, spriteTexture);
		glPushMatrix();
		
		glEnable(GL_BLEND);		// Turn Blending On
		glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);

		glTranslatef(Xpos,Ypos,0.1f);
		glRotatef(Rot, 0.0f, 0.0f, 1.0f);
		glScalef(Wid, Hei,1.0f);

		
		//glClear(GL_COLOR_BUFFER_BIT); //cls
		glVertexPointer(2, GL_FLOAT, 0, BasicVertices);
		GLfloat Coords[] = {
			tox+0,toy+(Hei/th),
			tox+0, toy+0,
			tox+(Wid/tw), toy+(Hei/th),
			tox+(Wid/tw), toy+0,};
		
		glEnableClientState(GL_VERTEX_ARRAY);
		glTexCoordPointer(2, GL_FLOAT, 0, Coords);
		glEnableClientState(GL_TEXTURE_COORD_ARRAY);
		glDrawArrays(GL_TRIANGLE_STRIP,0, 4);
		glPopMatrix();
	}

-(void)DrawSolidX:(float)Xpos Y:(float)Ypos W:(float)Wid H:(float)Hei R:(float)Rot {
	glPushMatrix();
	glDisable(GL_TEXTURE_2D);
	glTranslatef(Xpos,Ypos,0.1f);
	glScalef(Wid, Hei,1.0f);
	glRotatef(Rot, 0.0f, 0.0f, 1.0f);
	
	//glClear(GL_COLOR_BUFFER_BIT); //cls
	glVertexPointer(2, GL_FLOAT, 0, BasicVertices);
	
	glEnableClientState(GL_VERTEX_ARRAY);
	//glTexCoordPointer(2, GL_SHORT, 0, BasicCoords);
	//glEnableClientState(GL_TEXTURE_COORD_ARRAY);
	glDrawArrays(GL_TRIANGLE_STRIP,0, 4);
	glPopMatrix();
	glEnable(GL_TEXTURE_2D);
}
-(void)DrawSpriteX:(float)Xpos Y:(float)Ypos W:(float)Wid H:(float)Hei R:(float)Rot 
{
	glBindTexture(GL_TEXTURE_2D, spriteTexture);
	glPushMatrix();
	
	glEnable(GL_BLEND);		// Turn Blending On
	glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);
	
	glTranslatef(Xpos,Ypos,0.1f);
	glScalef(Wid, Hei,1.0f);
	glRotatef(Rot, 0.0f, 0.0f, 1.0f);
	
	//glClear(GL_COLOR_BUFFER_BIT); //cls
	glVertexPointer(2, GL_FLOAT, 0, BasicVertices);
	
	glEnableClientState(GL_VERTEX_ARRAY);
	glTexCoordPointer(2, GL_SHORT, 0, BasicCoords);
	glEnableClientState(GL_TEXTURE_COORD_ARRAY);
	glDrawArrays(GL_TRIANGLE_STRIP,0, 4);
	glPopMatrix();
}
-(void)DrawLetterX:(float)Xpos Y:(float)Ypos W:(float)Wid H:(float)Hei R:(float)Rot F:(int)framenum Flip:(int)f
{
	float xt,yt,wt,ht;			
	
	float xpos=(int)(framenum%(int)TileX);
	float ypos=(int)(framenum/(int)TileX);
	//xpos=1;
	//ypos=1;
	//	TileX=2;
	//	TileY=2;
	wt=1/TileX;
	ht=1/TileY;
	
	xt=wt*xpos;
	yt=ht*ypos;
	
	///	NSLog(@"%f %f",xpos,ypos);
	
	GLfloat Coords[] = {
		xt,yt+ht+.01f,
		xt, yt+.01f,
		xt+wt, yt+ht+.01f,
	xt+wt, yt+.01f,};
	//	glTexCoord2f(xt, yt); glVertex3f(-(w/2), -(h/2),  0.0f);
	//	glTexCoord2f(xt, yt+ht); glVertex3f(  -(w/2),(h/2),  0.0f);
	//	glTexCoord2f(xt+wt, yt+ht); glVertex3f( (w/2),  (h/2),  0.0f);
	//	glTexCoord2f(xt+wt, yt); glVertex3f((w/2),-(h/2),0.0f);
//	glTexCoord2f(cx-.01,1-cy-0.0540f);			// Texture Coord (Bottom Left)
//	glVertex2i(0,0);						// Vertex Coord (Bottom Left)
//	glTexCoord2f(cx+0.0540f,1-cy-0.0540f);	// Texture Coord (Bottom Right)
//	glVertex2i(16,0);						// Vertex Coord (Bottom Right)
//	glTexCoord2f(cx+0.0540f,1-cy);			// Texture Coord (Top Right)
//	glVertex2i(16,16);						// Vertex Coord (Top Right)
//	glTexCoord2f(cx-.01,1-cy);					// Texture Coord (Top Left)
//	glVertex2i(0,16);						// Vertex Coord (Top Left)
	
	
	glBindTexture(GL_TEXTURE_2D, spriteTexture);
	glPushMatrix();
	
	glEnable(GL_BLEND);		// Turn Blending On
	glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);
	glTranslatef(Xpos,Ypos,0.1f);
	glScalef(Wid, Hei,1.0f);
	//glRotatef(Rot, 0.0f, 0.0f, 1.0f);
	//glClear(GL_COLOR_BUFFER_BIT); //cls
	switch (f) {
		case 0:
			glVertexPointer(2, GL_FLOAT, 0, BasicVertices);
			break;
		case 1:
			glVertexPointer(2, GL_FLOAT, 0, BasicVerticesXflip);
			break;
	}
	//glVertexPointer(2, GL_FLOAT, 0, BasicVerticesX);
	glEnableClientState(GL_VERTEX_ARRAY);
	glTexCoordPointer(2, GL_FLOAT, 0, Coords);
	glEnableClientState(GL_TEXTURE_COORD_ARRAY);
	glDrawArrays(GL_TRIANGLE_STRIP,0, 4);
	glPopMatrix();
}

-(void)DrawAniSpriteX:(float)Xpos Y:(float)Ypos W:(float)Wid H:(float)Hei R:(float)Rot F:(int)framenum Flip:(int)f
{
	float xt,yt,wt,ht;			
	
	 float xpos=(int)(framenum%(int)TileX);
	 float ypos=(int)(framenum/(int)TileX);
	//xpos=1;
	//ypos=1;
//	TileX=2;
//	TileY=2;
	wt=1/TileX;
	 ht=1/TileY;
	 
	 xt=wt*xpos;
	 yt=ht*ypos;
	
///	NSLog(@"%f %f",xpos,ypos);
	
	GLfloat Coords[] = {
		xt,yt+ht,
		xt, yt,
		xt+wt, yt+ht,
	xt+wt, yt,};
//	glTexCoord2f(xt, yt); glVertex3f(-(w/2), -(h/2),  0.0f);
//	glTexCoord2f(xt, yt+ht); glVertex3f(  -(w/2),(h/2),  0.0f);
//	glTexCoord2f(xt+wt, yt+ht); glVertex3f( (w/2),  (h/2),  0.0f);
//	glTexCoord2f(xt+wt, yt); glVertex3f((w/2),-(h/2),0.0f);
	
	
	glBindTexture(GL_TEXTURE_2D, spriteTexture);
	glPushMatrix();
	
	glEnable(GL_BLEND);		// Turn Blending On
	glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);
	glTranslatef(Xpos,Ypos,0.1f);
	glScalef(Wid, Hei,1.0f);
	glRotatef(Rot, 0.0f, 0.0f, 1.0f);
	//glClear(GL_COLOR_BUFFER_BIT); //cls
	switch (f) {
		case 0:
			glVertexPointer(2, GL_FLOAT, 0, BasicVertices);
			break;
		case 1:
			glVertexPointer(2, GL_FLOAT, 0, BasicVerticesXflip);
			break;
	}
	//glVertexPointer(2, GL_FLOAT, 0, BasicVerticesX);
	glEnableClientState(GL_VERTEX_ARRAY);
	glTexCoordPointer(2, GL_FLOAT, 0, Coords);
	glEnableClientState(GL_TEXTURE_COORD_ARRAY);
	glDrawArrays(GL_TRIANGLE_STRIP,0, 4);
	glPopMatrix();
}


-(void)DefineTileX:(int)Xsize Y:(int)Ysize
{
	TileX=Xsize;
	TileY=Ysize;
}
-(void)init
{
	inuse=NO;
	[super init];
	
}
-(void)MidPrintTextX:(float)x Y:(float)y Z:(float)z Text:(char *)textline
{
	//for (int i=0;i<strlen(textline);i++
	int i=0;	
	while (textline[i]!='\0'){
		float shift=strlen(textline)+1;
		shift/=2;
		[self DrawLetterX:(x+((i+1)-shift)*z*.66) Y:y W:z H:z R:0 F:textline[i]-32 Flip:0];
		i++;
	}
}
-(void)PrintTextX:(float)x Y:(float)y Z:(float)z Text:(char *)textline
{
	//for (int i=0;i<strlen(textline);i++
	int i=0;	
	while (textline[i]!='\0'){
		[self DrawLetterX:x+i*z*.66 Y:y W:z H:z R:0 F:textline[i]-32 Flip:0];
		i++;
	}	
	
	
	//glMatrixMode(GL_PROJECTION);						// Select The Projection Matrix
	//glPushMatrix();										// Store The Projection Matrix
	//glBindTexture(GL_TEXTURE_2D, texture);			// Select Our Font Texture
	//glLoadIdentity();									// Reset The Projection Matrix
	//glOrtho(0,640,0,480,-1,1);							// Set Up An Ortho Screen
	//glMatrixMode(GL_MODELVIEW);							// Select The Modelview Matrix
	//glPushMatrix();										// Store The Modelview Matrix
	//glMatrixMode(GL_PROJECTION);
	
	//glLoadIdentity();									// Reset The Modelview Matrix
	
	/*
	glTranslated(x,y,0.5f);
	
	// Create Ortho 640x480 View (0,0 At Top Left)
	// Position The Text (0,0 - Bottom Left)
	glScalef(z,z,0);
	glEnable(GL_BLEND);		// Turn Blending On
	glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);		// Blending Function For Translucency Based On Source Alpha Value ( NEW 
	//glColor4f(1.0f,1.0f,1.0f,1.00f);			// Full Brightness, 50% Alpha ( NEW )
	
	glListBase(base-32+(128*set));						// Choose The Font Set (0 or 1)
	glCallLists(strlen(textline),GL_UNSIGNED_BYTE,textline);// Write The Text To The Screen
	//glMatrixMode(GL_PROJECTION);						// Select The Projection Matrix
	//glPopMatrix();										// Restore The Old Projection Matrix
	//glMatrixMode(GL_MODELVIEW);							// Select The Modelview Matrix
	//glMatrixMode(GL_MODELVIEW);							// Select The Modelview Matrix
	glDisable(GL_BLEND);		// Turn Blending On
	glPopMatrix();										// Restore The Old Projection Matrix
	
	*/
}
- (void)dealloc {
	if (inuse) glDeleteTextures(1, &spriteTexture);
	[super dealloc];
}
@end
